package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;


import java.security.Security;

public class GMSSLRandomUtils {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /************************************************************************************
     *                                      随机数                                      *
     ************************************************************************************/
    /**
     * 使用 密码机 生成随机数
     *
     * @param len 随机数长度
     * @return BASE 64 编码的随机数
     * @throws SdfSDKException Sdf SDK 异常
     */
    public static String generateRandomByYunhsm(int len) throws SdfSDKException {
        return generateRandomBySdf(SdfCryptoType.YUNHSM, len);
    }

    /**
     * 使用 PCIE 生成随机数
     *
     * @param len 随机数长度
     * @return BASE 64 编码的随机数
     * @throws SdfSDKException Sdf SDK 异常
     */
    public static String generateRandomByPcie(int len) throws SdfSDKException {
        return generateRandomBySdf(SdfCryptoType.PCIE, len);
    }

    /**
     * 使用 密码机 生成随机数
     *
     * @param sdfCryptoType SDF 算法类型
     * @param len           随机数长度
     * @return BASE 64 编码的随机数
     * @throws SdfSDKException Sdf SDK 异常
     */
    public static String generateRandomBySdf(SdfCryptoType sdfCryptoType, int len) throws SdfSDKException {
        SdfRandom sdfRandom = new SdfRandom(sdfCryptoType);
        byte[] random = sdfRandom.generateRandom(len);
        return GMSSLByteArrayUtils.base64Encode(random);
    }
}
