package com.xdja.pki.gmssl.x509.utils.bean;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public enum GMSSLSignatureAlgorithm {
    // sm2 sm3
    SM3_WITH_SM2(GMObjectIdentifiers.sm2sign_with_sm3, "SM3withSM2"),
    // sha1 rsa
    SHA1_WITH_RSA(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA"),
    // sha256 rsa
    SHA256_WITH_RSA(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA"),
    // sha512 rsa
    SHA512_WITH_RSA(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA"),
    ;

    private ASN1ObjectIdentifier aid;
    private String sigAlgName;

    public ASN1ObjectIdentifier getAid() {
        return aid;
    }

    public String getSigAlgName() {
        return sigAlgName;
    }

    GMSSLSignatureAlgorithm(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public AlgorithmIdentifier convertAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlgName);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        return convertContentSignatureAlgorithm(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(ASN1ObjectIdentifier aid) {
        if (aid == GMObjectIdentifiers.sm2sign_with_sm3) {
            return SM3_WITH_SM2;
        } else if (aid == PKCSObjectIdentifiers.sha1WithRSAEncryption){
            return SHA1_WITH_RSA;
        }  else if (aid == PKCSObjectIdentifiers.sha256WithRSAEncryption){
            return SHA256_WITH_RSA;
        }  else if (aid == PKCSObjectIdentifiers.sha512WithRSAEncryption){
            return SHA512_WITH_RSA;
        } else {
            return null;
        }
    }
}
