/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECEngine;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLECIESEncryptUtils {
    private static Logger logger = LoggerFactory.getLogger((String)GMSSLECIESEncryptUtils.class.getName());

    public static byte[] encrypt(GMSSLCryptoType cryptoType, PublicKey publicKey, byte[] data) throws Exception {
        switch (cryptoType) {
            case BC: {
                return GMSSLBCCipherUtils.encryptData((String)"ECIES", (PublicKey)publicKey, (byte[])data);
            }
            case YUNHSM: {
                return GMSSLECIESEncryptUtils.encrypt(SdfCryptoType.YUNHSM, publicKey, data);
            }
            case PCIE: {
                return GMSSLECIESEncryptUtils.encrypt(SdfCryptoType.PCIE, publicKey, data);
            }
        }
        throw new Exception("un support this crypto" + (Object)((Object)cryptoType));
    }

    public static String encrypt(GMSSLCryptoType cryptoType, PublicKey publicKey, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLECIESEncryptUtils.encrypt(cryptoType, publicKey, GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] decrypt(GMSSLCryptoType cryptoType, PrivateKey privateKey, byte[] cipher) throws Exception {
        if (privateKey instanceof SdfPrivateKey && cryptoType == GMSSLCryptoType.BC) {
            throw new Exception("privateKey is sdfPrivateKey, but crypto type is bc");
        }
        switch (cryptoType) {
            case YUNHSM: {
                return GMSSLECIESEncryptUtils.decrypt(SdfCryptoType.YUNHSM, privateKey, cipher);
            }
            case BC: {
                return GMSSLBCCipherUtils.decryptData((String)"ECIES", (PrivateKey)privateKey, (byte[])cipher);
            }
            case PCIE: {
                return GMSSLECIESEncryptUtils.decrypt(SdfCryptoType.PCIE, privateKey, cipher);
            }
        }
        throw new Exception("un support this crypto" + (Object)((Object)cryptoType));
    }

    public static String decrypt(GMSSLCryptoType cryptoType, PrivateKey privateKey, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLECIESEncryptUtils.decrypt(cryptoType, privateKey, GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    private static byte[] encrypt(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] data) throws Exception {
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType.getSdfSDK(), GMSSLECUtils.NISTp256);
        sdfECEngine.init(true, (CipherParameters)new SdfECKeyParameters((ECPublicKey)publicKey));
        byte[] sdfCipher = sdfECEngine.encrypt(data);
        sdfECEngine.release();
        return sdfCipher;
    }

    private static byte[] decrypt(SdfCryptoType sdfCryptoType, PrivateKey privateKey, byte[] cipher) throws Exception {
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType.getSdfSDK(), GMSSLECUtils.NISTp256);
        sdfECEngine.init(false, (CipherParameters)new SdfECKeyParameters((SdfPrivateKey)privateKey));
        byte[] data = sdfECEngine.decrypt(cipher);
        sdfECEngine.release();
        return data;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

