/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKey;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;

public class GMSSLRSAKeyUtils {
    public static final String RSA_ALGORITHM_NAME = "RSA";
    public static final int RSA_KEY_SIZE_1024 = 1024;
    public static final int RSA_KEY_SIZE_2048 = 2048;

    public static KeyPair generateKeyPairByBC(int keySize) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(RSA_ALGORITHM_NAME, "BC");
        kpGen.initialize(keySize);
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateKeyPairByYunHsm(int keySize) throws SdfSDKException, InvalidKeySpecException, NoSuchProviderException, NoSuchAlgorithmException {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
        SdfRsaKeyPair sdfRsaKeyPair = sdfSDK.generateKeyPairRsa(keySize);
        sdfSDK.release();
        SdfRSAPrivateKey rsaPrivateKey = sdfRsaKeyPair.getSdfRSAPrivateKey();
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getM()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getE()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getD()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPrime()[0]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPrime()[1]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPexp()[0]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPexp()[1]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getCoef()));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_NAME, "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(spec);
        SdfRSAPublicKey rsaPublicKey = sdfRsaKeyPair.getSdfRSAPublicKey();
        RSAPublicKeySpec spec1 = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])rsaPublicKey.getM()), BigIntegers.fromUnsignedByteArray((byte[])rsaPublicKey.getE()));
        PublicKey pk = keyFactory.generatePublic(spec1);
        return new KeyPair(pk, privateKey);
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password.getBytes());
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index) throws SdfSDKException {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index) throws SdfSDKException {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index) throws SdfSDKException {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index) throws SdfSDKException {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

