/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECEngine;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLSM2EncryptUtils {
    private static Logger logger = LoggerFactory.getLogger((String)GMSSLSM2EncryptUtils.class.getName());

    public static String encryptByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static byte[] encryptByBC(PublicKey publicKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        return GMSSLSM2EncryptUtils.encryptByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
    }

    public static String encryptByYunhsm(PublicKey publicKey, String base64Data) throws InvalidCipherTextException, SdfSDKException {
        return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.YUNHSM, publicKey, base64Data);
    }

    public static String encryptByPcie(PublicKey publicKey, String base64Data) throws InvalidCipherTextException, SdfSDKException {
        return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.PCIE, publicKey, base64Data);
    }

    public static String encryptBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sdfCipher = GMSSLSM2EncryptUtils.encryptBySdf(sdfCryptoType, publicKey, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])sdfCipher);
    }

    public static String decryptByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static String decryptByYunhsm(int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptByPcie(int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static String encryptASN1ByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptASN1ByBC(publicKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static byte[] encryptASN1ByBC(PublicKey publicKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptASN1ByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return cipher;
    }

    public static String encryptASN1ByYunhsm(PublicKey publicKey, String base64Data) throws CryptoException, SdfSDKException {
        return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.YUNHSM, publicKey, base64Data);
    }

    public static String encryptASN1ByPcie(PublicKey publicKey, String base64Data) throws CryptoException, SdfSDKException {
        return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.PCIE, publicKey, base64Data);
    }

    public static String encryptASN1BySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sdfCipher = GMSSLSM2EncryptUtils.encryptASN1BySdf(sdfCryptoType, publicKey, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])sdfCipher);
    }

    public static String decryptASN1ByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1ByBC(privateKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static byte[] decryptASN1ByBC(PrivateKey privateKey, byte[] data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return out;
    }

    public static String decryptASN1ByYunhsm(int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptASN1ByPcie(int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptASN1BySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data) throws SdfSDKException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1BySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static byte[] encryptByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] decryptByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] encryptASN1ByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException, IOException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        byte[] ciphertext = sm2Engine.processBlock(input, inOff, length);
        ECCurve curve = keyParameter.getParameters().getCurve();
        int curveLength = (curve.getFieldSize() + 7) / 8;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(ciphertext, inOff, c1, 0, c1.length);
        ECPoint c1P = curve.decodePoint(c1);
        byte[] xb = c1P.getXCoord().getEncoded();
        byte[] yb = c1P.getYCoord().getEncoded();
        SM3Digest digest = new SM3Digest();
        byte[] c2 = new byte[length];
        System.arraycopy(ciphertext, ciphertext.length - length - digest.getDigestSize(), c2, 0, length);
        byte[] c3 = new byte[digest.getDigestSize()];
        System.arraycopy(ciphertext, ciphertext.length - digest.getDigestSize(), c3, 0, digest.getDigestSize());
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(xb, yb, c3, c2);
        byte[] result = asn1SM2Cipher.toASN1Primitive().getEncoded();
        return result;
    }

    public static byte[] decryptASN1ByBC(ECKeyParameters keyParameter, byte[] input) throws InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptASN1ByBC(keyParameter, input, 0, input.length);
    }

    public static byte[] decryptASN1ByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        byte[] sm2CipherASN1 = new byte[length];
        System.arraycopy(input, inOff, sm2CipherASN1, 0, length);
        ASN1SM2Cipher asn1 = ASN1SM2Cipher.getInstance((Object)sm2CipherASN1);
        ECCurve curve = keyParameter.getParameters().getCurve();
        BigInteger x = asn1.getxCoordinate();
        BigInteger y = asn1.getyCoordinate();
        ECPoint point = curve.createPoint(x, y);
        byte[] c1 = point.getEncoded(false);
        byte[] c2 = asn1.getCipherText();
        byte[] c3 = asn1.getHash();
        byte[] ciphertext = Arrays.concatenate((byte[])c1, (byte[])c2, (byte[])c3);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        byte[] M = sm2Engine.processBlock(ciphertext, 0, ciphertext.length);
        return M;
    }

    public static byte[] encryptBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] input, int inOff, int length) throws SdfSDKException, InvalidCipherTextException {
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType);
        sdfECEngine.init(true, (CipherParameters)new SdfECKeyParameters((ECPublicKey)publicKey));
        byte[] sdfCipher = sdfECEngine.processBlock(input, inOff, length);
        sdfECEngine.release();
        return sdfCipher;
    }

    public static byte[] decryptBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] input, int inOff, int length) throws SdfSDKException, InvalidCipherTextException {
        SdfECEngine sdfECEngineDecrypt = new SdfECEngine(sdfCryptoType);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        sdfECEngineDecrypt.init(false, (CipherParameters)new SdfECKeyParameters(sdfPrivateKey));
        byte[] out = sdfECEngineDecrypt.processBlock(input, inOff, length);
        sdfECEngineDecrypt.release();
        return out;
    }

    public static byte[] encryptASN1BySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] input, int inOff, int length) throws SdfSDKException, InvalidCipherTextException {
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType);
        sdfECEngine.init(true, (CipherParameters)new SdfECKeyParameters((ECPublicKey)publicKey));
        byte[] sdfCipher = sdfECEngine.processBlockASN1(input, inOff, length);
        sdfECEngine.release();
        return sdfCipher;
    }

    public static byte[] decryptASN1BySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] input, int inOff, int length) throws SdfSDKException, InvalidCipherTextException {
        SdfECEngine sdfECEngineDecrypt = new SdfECEngine(sdfCryptoType);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        sdfECEngineDecrypt.init(false, (CipherParameters)new SdfECKeyParameters(sdfPrivateKey));
        byte[] out = sdfECEngineDecrypt.processBlockASN1(input, inOff, length);
        sdfECEngineDecrypt.release();
        return out;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

