/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifierProvider;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class GMSSLContentVerifierProviderUtils {
    public static ContentVerifierProvider generateContentVerifierByBC(PublicKey publicKey) throws OperatorCreationException {
        return GMSSLContentVerifierProviderUtils.generateContentVerifierByBC(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
    }

    public static ContentVerifierProvider generateContentVerifierByBC(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return new JcaContentVerifierProviderBuilder().setProvider("BC").build(subjectPublicKeyInfo);
    }

    public static ContentVerifierProvider generateContentVerifierByYunHsm(PublicKey publicKey) {
        return GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(SdfCryptoType.YUNHSM, publicKey);
    }

    public static ContentVerifierProvider generateContentVerifierByPcie(PublicKey publicKey) {
        return GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(SdfCryptoType.PCIE, publicKey);
    }

    public static ContentVerifierProvider generateContentVerifierBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey) {
        return new SdfContentVerifierProvider(sdfCryptoType, publicKey);
    }

    public static ContentVerifierProvider generateContentVerifierBySdfHSM(SdfCryptoType sdfCryptoType, PublicKey publicKey) {
        return new SdfContentVerifierProvider(sdfCryptoType, publicKey, false);
    }
}

