/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLHttpUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.GMSSLX500NameUtils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmInfoEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLYunHsmUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLYunHsmUtils.class);

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(yunHsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxPath, encPfxPath, trustP7bPath);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        File signPfx = new File(signPfxPath);
        FileInputStream signPfxStream = new FileInputStream(signPfx);
        File encPfx = new File(encPfxPath);
        FileInputStream encPfxStream = new FileInputStream(encPfx);
        File trustP7b = new File(trustP7bPath);
        FileInputStream trustP7bStream = new FileInputStream(trustP7b);
        return GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port, String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream) throws Exception {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(yunHsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream) throws Exception {
        YunHsmExceptionEnum yunHsmExceptionEnum;
        ByteArrayInputStream signTestInput = null;
        ByteArrayInputStream encTestInput = null;
        ByteArrayInputStream trustTestInput = null;
        ByteArrayInputStream signInput = null;
        ByteArrayInputStream encInput = null;
        ByteArrayInputStream trustInput = null;
        if (signPfxStream != null) {
            ByteArrayOutputStream signByteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)signPfxStream, (OutputStream)signByteOut);
            signTestInput = new ByteArrayInputStream(signByteOut.toByteArray());
            signInput = new ByteArrayInputStream(signByteOut.toByteArray());
        }
        if (encPfxStream != null) {
            ByteArrayOutputStream encByteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)encPfxStream, (OutputStream)encByteOut);
            encTestInput = new ByteArrayInputStream(encByteOut.toByteArray());
            encInput = new ByteArrayInputStream(encByteOut.toByteArray());
        }
        if (trustP7bStream != null) {
            ByteArrayOutputStream trustByteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)trustP7bStream, (OutputStream)trustByteOut);
            trustTestInput = new ByteArrayInputStream(trustByteOut.toByteArray());
            trustInput = new ByteArrayInputStream(trustByteOut.toByteArray());
        }
        if ((yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, signTestInput, encTestInput, trustTestInput)) != YunHsmExceptionEnum.NORMAL) {
            return yunHsmExceptionEnum;
        }
        String confPath = yunhsmPath + File.separator + "conf";
        GMSSLYunHsmUtils.writeConf(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, confPath);
        YunHsmExceptionEnum checkCert = GMSSLYunHsmUtils.storeCert(signPfxPassword, encPfxPassword, signInput, encInput, trustInput, yunhsmPath, confPath);
        if (checkCert != YunHsmExceptionEnum.NORMAL) {
            logger.info("\u914d\u7f6e\u6587\u4ef6\u6821\u9a8c\u5931\u8d25 {}", (Object)checkCert);
            return checkCert;
        }
        HsmConnectionProviderImpl.getInstance().reopen();
        logger.info("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6\u6210\u529f");
        return YunHsmExceptionEnum.NORMAL;
    }

    public static YunHsmExceptionEnum testConnect(String ip, int port, String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream) throws Exception {
        String yunhsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.testConnect(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream);
    }

    public static YunHsmExceptionEnum testConnect(String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        String yunhsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.testConnect(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxPath, encPfxPath, trustP7bPath);
    }

    public static YunHsmExceptionEnum testConnect(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        File signPfx = new File(signPfxPath);
        FileInputStream signPfxStream = new FileInputStream(signPfx);
        File encPfx = new File(encPfxPath);
        FileInputStream encPfxStream = new FileInputStream(encPfx);
        File trustP7b = new File(trustP7bPath);
        FileInputStream trustP7bStream = new FileInputStream(trustP7b);
        return GMSSLYunHsmUtils.testConnect(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream);
    }

    public static YunHsmExceptionEnum testConnect(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, InputStream signPfxStream, InputStream encPfxStream, InputStream trustP7bStream) throws Exception {
        String confTest = yunhsmPath + File.separator + "confTest" + File.separator;
        YunHsmExceptionEnum checkCert = GMSSLYunHsmUtils.storeCert(signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream, yunhsmPath, confTest);
        if (checkCert != YunHsmExceptionEnum.NORMAL) {
            logger.info("\u914d\u7f6e\u6587\u4ef6\u6821\u9a8c\u5931\u8d25 {}", (Object)checkCert);
            return checkCert;
        }
        GMSSLYunHsmUtils.writeConf(yunhsmPath, ip, port, signPfxPassword, encPfxPassword, confTest);
        return GMSSLYunHsmUtils.testConnectWithConf(ip, port, confTest);
    }

    public static YunHsmExceptionEnum testConnect(String host, int port) {
        try {
            logger.debug("\u5f00\u59cb\u6d4b\u8bd5\u94fe\u63a5 \u914d\u7f6e\u6587\u4ef6\u8def\u5f84 host={} port={}", (Object)host, (Object)port);
            if (!GMSSLHttpUtils.isHostConnectivity((String)host, (int)port)) {
                return YunHsmExceptionEnum.TELNET_PORT_FAILURE;
            }
            YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
            sdfSDK.init();
            sdfSDK.testConnect();
            sdfSDK.release();
            logger.info("\u6d4b\u8bd5\u94fe\u63a5\u6210\u529f host={} port={}", (Object)host, (Object)port);
        }
        catch (SdfSDKException e) {
            logger.error("\u6d4b\u8bd5\u94fe\u63a5\u5931\u8d25\uff0c\u6253\u5f00\u8bbe\u5907\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
        return YunHsmExceptionEnum.NORMAL;
    }

    public static YunHsmExceptionEnum testConnectWithConf(String host, int port, String confPath) {
        confPath = confPath + File.separator + "yunhsmsdk.conf";
        try {
            logger.debug("\u5f00\u59cb\u6d4b\u8bd5\u94fe\u63a5 \u914d\u7f6e\u6587\u4ef6\u8def\u5f84 host={} port={} confPath={}", new Object[]{host, port, confPath});
            if (!GMSSLHttpUtils.isHostConnectivity((String)host, (int)port)) {
                return YunHsmExceptionEnum.TELNET_PORT_FAILURE;
            }
            YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
            sdfSDK.init();
            sdfSDK.testConnect(confPath);
            sdfSDK.release();
            logger.info("\u6d4b\u8bd5\u94fe\u63a5\u6210\u529f host={} port={} confPath={}", new Object[]{host, port, confPath});
        }
        catch (SdfSDKException e) {
            logger.error("\u6d4b\u8bd5\u94fe\u63a5\u5931\u8d25\uff0c\u6253\u5f00\u8bbe\u5907\u5931\u8d25\uff0chost={} port={} confPath={}", new Object[]{host, port, confPath, e});
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
        return YunHsmExceptionEnum.NORMAL;
    }

    public static boolean testConnect() {
        try {
            YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
            sdfSDK.init();
            sdfSDK.testConnect();
            sdfSDK.release();
            logger.info("\u6d4b\u8bd5\u94fe\u63a5\u6210\u529f");
            return true;
        }
        catch (SdfSDKException e) {
            logger.error("\u6d4b\u8bd5\u94fe\u63a5\u5931\u8d25\uff0c\u6253\u5f00\u8bbe\u5907\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static void resetYunHsm() throws IOException {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        GMSSLYunHsmUtils.resetYunHsm(yunHsmPath);
    }

    public static void resetYunHsm(String yunhsmPath) throws IOException {
        String bakPath = yunhsmPath + File.separator + "confBak" + File.separator;
        String sourcePath = yunhsmPath + File.separator + "conf" + File.separator;
        File bakfile = new File(bakPath);
        if (!bakfile.exists()) {
            logger.info("\u5bc6\u7801\u673a\u672a\u8fdb\u884c\u4efb\u4f55\u914d\u7f6e\uff0c\u65e0\u9700\u521d\u59cb\u5316");
            return;
        }
        GMSSLFileUtils.deleteDirectory((String)sourcePath);
        File file = new File(sourcePath);
        file.mkdir();
        GMSSLFileUtils.copyDir((String)bakPath, (String)sourcePath);
        GMSSLFileUtils.deleteDirectory((String)bakPath);
        logger.info("\u5bc6\u7801\u673a\u521d\u59cb\u5316\u6210\u529f");
    }

    public static YunHsmInfoEntry getYunHsmInfo() throws IOException {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.getYunHsmInfo(yunHsmPath);
    }

    public static YunHsmInfoEntry getYunHsmInfo(String yunhsmPath) throws IOException {
        String confPath = yunhsmPath + File.separator + "conf" + File.separator + "yunhsmsdk.conf";
        YunHsmInfoEntry yunHsmInfoEntry = new YunHsmInfoEntry();
        File file = new File(confPath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject certificate = dataJson.getJSONObject("Certificate");
        JSONObject softCert = certificate.getJSONObject("SoftCert");
        JSONObject signatureCertificate = softCert.getJSONObject("SignatureCertificate");
        yunHsmInfoEntry.setSignCertPassword(signatureCertificate.getString("pin"));
        String signCertName = signatureCertificate.getString("file");
        yunHsmInfoEntry.setSignCertName(signCertName.substring(signCertName.indexOf("sign")));
        JSONObject encryptCertificate = softCert.getJSONObject("EncryptCertificate");
        yunHsmInfoEntry.setEncCertPassword(encryptCertificate.getString("pin"));
        String encCertName = encryptCertificate.getString("file");
        yunHsmInfoEntry.setEncCertName(encCertName.substring(encCertName.indexOf("enc")));
        JSONObject hsm = dataJson.getJSONObject("hsm");
        yunHsmInfoEntry.setServerIp(hsm.getString("ip"));
        yunHsmInfoEntry.setServerPort(Integer.valueOf(hsm.getString("port")));
        JSONObject ssl = dataJson.getJSONObject("ssl");
        String caCertName = ssl.getString("CertificatePath");
        yunHsmInfoEntry.setCaCertName(caCertName.substring(caCertName.indexOf("trust")));
        yunHsmInfoEntry.setYunHsmType("\u4fe1\u5927\u6377\u5b89\u670d\u52a1\u5668\u5bc6\u7801\u673a");
        return yunHsmInfoEntry;
    }

    private static void deleteConDir(String yunHsmPath) {
        File confDir = new File(yunHsmPath + File.separator + "conf");
        if (confDir.exists()) {
            GMSSLFileUtils.deleteDirectory((String)(yunHsmPath + File.separator + "conf"));
        }
        confDir.mkdir();
    }

    private static String getYunHsmPath() {
        String yunhsmPath;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            yunhsmPath = "C:\\Program Files (x86)\\yunhsmsdk";
            File file = new File(yunhsmPath);
            if (!file.exists()) {
                yunhsmPath = "C:\\Program Files\\yunhsmsdk";
            }
        } else {
            yunhsmPath = "/usr/local/yunhsmsdk";
        }
        return yunhsmPath;
    }

    private static void backUpConf(String path) throws IOException {
        String bakPath = path + File.separator + "confBak" + File.separator;
        File bakFile = new File(bakPath);
        String sourcePath = path + File.separator + "conf" + File.separator;
        logger.info("confFile \u5907\u4efd\u6210\u529f");
        if (bakFile.exists() && bakFile.isDirectory()) {
            return;
        }
        GMSSLFileUtils.copyDir((String)sourcePath, (String)bakPath);
        logger.info("\u5907\u4efd\u6210\u529f");
    }

    private static YunHsmExceptionEnum storeCert(String signPfxPassword, String encPfxPassword, InputStream signPfxStream, InputStream encPfxStream, InputStream trustP7bStream, String yunHsmPath, String writeConfPath) throws Exception {
        List trustList;
        KeyStore encKse;
        KeyStore signKse;
        File signPfx;
        YunHsmInfoEntry yunHsmInfo = GMSSLYunHsmUtils.getYunHsmInfo(yunHsmPath);
        if (signPfxStream == null) {
            String signCertName = yunHsmInfo.getSignCertName();
            signPfx = new File(yunHsmPath + File.separator + "conf" + File.separator + signCertName);
            signPfxStream = new FileInputStream(signPfx);
        }
        if (encPfxStream == null) {
            String encCertName = yunHsmInfo.getEncCertName();
            signPfx = new File(yunHsmPath + File.separator + "conf" + File.separator + encCertName);
            encPfxStream = new FileInputStream(signPfx);
        }
        if (trustP7bStream == null) {
            String caCertName = yunHsmInfo.getCaCertName();
            File trustP7b = new File(yunHsmPath + File.separator + "conf" + File.separator + caCertName);
            trustP7bStream = new FileInputStream(trustP7b);
        }
        ByteArrayOutputStream signByteOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)signPfxStream, (OutputStream)signByteOut);
        ByteArrayOutputStream encByteOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)encPfxStream, (OutputStream)encByteOut);
        ByteArrayOutputStream trustByteOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)trustP7bStream, (OutputStream)trustByteOut);
        try {
            ByteArrayInputStream si = new ByteArrayInputStream(signByteOut.toByteArray());
            signKse = KeyStore.getInstance("pkcs12", "BC");
            signKse.load(si, signPfxPassword.toCharArray());
            logger.info("\u7b7e\u540dPFX \u89e3\u6790\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u8bc1\u4e66\u4fdd\u62a4\u53e3\u4ee4\u4e0d\u80fd\u6253\u5f00\u52a0\u5bc6\u8bc1\u4e66", (Throwable)e);
            return YunHsmExceptionEnum.SIGN_PASSWORD_IS_ERROR;
        }
        try {
            ByteArrayInputStream ei = new ByteArrayInputStream(encByteOut.toByteArray());
            encKse = KeyStore.getInstance("pkcs12", "BC");
            encKse.load(ei, encPfxPassword.toCharArray());
            logger.info("\u52a0\u5bc6PFX \u89e3\u6790\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u8bc1\u4e66\u4fdd\u62a4\u53e3\u4ee4\u4e0d\u80fd\u6253\u5f00\u52a0\u5bc6\u8bc1\u4e66", (Throwable)e);
            return YunHsmExceptionEnum.ENC_PASSWORD_IS_ERROR;
        }
        try {
            ByteArrayInputStream ti = new ByteArrayInputStream(trustByteOut.toByteArray());
            trustList = GMSSLX509Utils.getCertsByCertChain((InputStream)ti);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5bc6\u7801\u673aCA\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR;
        }
        ByteArrayInputStream si = new ByteArrayInputStream(signByteOut.toByteArray());
        List signList = GMSSLX509Utils.readCertificatesFromP12((InputStream)si, (char[])signPfxPassword.toCharArray());
        for (int i = 0; i < signList.size(); ++i) {
            X509Certificate certificate = (X509Certificate)signList.get(i);
            boolean[] signKeyUsage = new boolean[]{true, true, false, false, false, false, false, false, false};
            boolean[] keyUsage = certificate.getKeyUsage();
            if (!Arrays.equals(signKeyUsage, keyUsage)) {
                logger.error("\u7b7e\u540d\u8bc1\u4e66\u5bc6\u94a5\u7528\u9014\u9519\u8bef\uff0c\u5e94\u4e3a {}, \u914d\u7f6e\u6587\u4ef6\u4e3a {}", (Object)signKeyUsage, (Object)keyUsage);
                return YunHsmExceptionEnum.SIGN_CERT_KEY_USAGE_IS_ERROR;
            }
            if (GMSSLX509Utils.verifyCert((X509Certificate)certificate, (List)trustList)) continue;
            logger.error("\u7b2c {} \u4e2a\u7b7e\u540d\u8bc1\u4e66 {} \u9a8c\u7b7e\u5931\u8d25", (Object)i, (Object)GMSSLX500NameUtils.getRFCStyleSubjectDN(certificate));
            return YunHsmExceptionEnum.SIGN_CERT_VERIFY_IS_ERROR;
        }
        logger.info("\u7b7e\u540d\u8bc1\u4e66\u9a8c\u7b7e\u5168\u90e8\u901a\u8fc7");
        ByteArrayInputStream ei = new ByteArrayInputStream(encByteOut.toByteArray());
        List encList = GMSSLX509Utils.readCertificatesFromP12((InputStream)ei, (char[])encPfxPassword.toCharArray());
        for (int i = 0; i < encList.size(); ++i) {
            X509Certificate certificate = (X509Certificate)encList.get(i);
            boolean[] signKeyUsage = new boolean[]{false, false, true, true, true, false, false, false, false};
            boolean[] keyUsage = certificate.getKeyUsage();
            if (!Arrays.equals(signKeyUsage, keyUsage)) {
                logger.error("\u52a0\u5bc6\u8bc1\u4e66\u5bc6\u94a5\u7528\u9014\u9519\u8bef\uff0c\u5e94\u4e3a {}, \u914d\u7f6e\u6587\u4ef6\u4e3a {}", (Object)signKeyUsage, (Object)keyUsage);
                return YunHsmExceptionEnum.ENC_CERT_KEY_USAGE_IS_ERROR;
            }
            if (GMSSLX509Utils.verifyCert((X509Certificate)((X509Certificate)encList.get(i)), (List)trustList)) continue;
            logger.error("\u7b2c {} \u4e2a\u52a0\u5bc6\u8bc1\u4e66 {} \u9a8c\u7b7e\u5931\u8d25", (Object)i, (Object)GMSSLX500NameUtils.getRFCStyleSubjectDN(certificate));
            return YunHsmExceptionEnum.ENC_CERT_VERIFY_IS_ERROR;
        }
        logger.info("\u52a0\u5bc6\u8bc1\u4e66\u9a8c\u7b7e\u5168\u90e8\u901a\u8fc7");
        File cp = new File(writeConfPath);
        if (!cp.exists()) {
            cp.mkdirs();
        }
        String sign = "sign_" + signPfxPassword;
        String enc = "enc_" + encPfxPassword;
        String trust = "trust_chain.p7b";
        GMSSLKeyStoreUtils.saveGMSSLPfx(signKse, signPfxPassword, writeConfPath, sign);
        GMSSLKeyStoreUtils.saveGMSSLPfx(encKse, encPfxPassword, writeConfPath, enc);
        ByteArrayInputStream ti = new ByteArrayInputStream(trustByteOut.toByteArray());
        GMSSLFileUtils.copyFile((InputStream)ti, (String)(writeConfPath + File.separator + trust));
        logger.info("\u7b7e\u540dPFX {}\u3001\u52a0\u5bc6PFX {}\u3001\u4fe1\u4efb\u8bc1\u4e66\u94fe {} \u5199\u5165 {} \u6210\u529f", new Object[]{sign, enc, trust, writeConfPath});
        return YunHsmExceptionEnum.NORMAL;
    }

    private static void writeConf(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, String writePath) throws IOException {
        GMSSLYunHsmUtils.backUpConf(yunhsmPath);
        String os = System.getProperty("os.name");
        String resourcePath = yunhsmPath + File.separator + "confBak" + File.separator + "yunhsmsdk.conf";
        String confPath = writePath + File.separator + "yunhsmsdk.conf";
        BufferedReader br = new BufferedReader(new FileReader(resourcePath));
        File file = new File(resourcePath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject certificate = dataJson.getJSONObject("Certificate");
        JSONObject softCert = certificate.getJSONObject("SoftCert");
        JSONObject signatureCertificate = softCert.getJSONObject("SignatureCertificate");
        signatureCertificate.put("pin", (Object)signPfxPassword);
        JSONObject encryptCertificate = softCert.getJSONObject("EncryptCertificate");
        encryptCertificate.put("pin", (Object)encPfxPassword);
        JSONObject hsm = dataJson.getJSONObject("hsm");
        hsm.put("ip", (Object)ip);
        hsm.put("port", (Object)port);
        JSONObject ssl = dataJson.getJSONObject("ssl");
        if (os.startsWith("Windows")) {
            signatureCertificate.put("file", (Object)(writePath + "\\sign_" + signPfxPassword + ".pfx"));
            encryptCertificate.put("file", (Object)(writePath + "\\enc_" + encPfxPassword + ".pfx"));
            ssl.put("CertificatePath", (Object)(writePath + "\\trust_chain.p7b"));
        } else {
            signatureCertificate.put("file", (Object)(writePath + "/sign_" + signPfxPassword + ".pfx"));
            encryptCertificate.put("file", (Object)(writePath + "/enc_" + encPfxPassword + ".pfx"));
            ssl.put("CertificatePath", (Object)(writePath + "/trust_chain.p7b"));
        }
        String ws = dataJson.toString();
        BufferedWriter bw = new BufferedWriter(new FileWriter(confPath));
        String s = GMSSLYunHsmUtils.formatJson(ws);
        bw.write(s);
        bw.flush();
        br.close();
        bw.close();
        logger.info("\u914d\u7f6e\u6587\u4ef6\u5199\u5165 {} \u6210\u529f", (Object)writePath);
    }

    public static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, ++indent);
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block5;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block5;
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, indent);
                    continue block5;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

