/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentSignerUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentVerifierUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLP10Utils {
    private static Logger logger = LoggerFactory.getLogger((String)GMSSLP10Utils.class.getName());

    public static PKCS10CertificationRequest generateP10SignByBC(String subject, PublicKey publicKey, PrivateKey privateKey, String algorithm) throws OperatorCreationException {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, privateKey);
        return GMSSLP10Utils.generateP10(subject, contentSigner, publicKey);
    }

    public static PKCS10CertificationRequest generateP10SignByYunhsm(String subject, PublicKey publicKey, int privateKeyIndex, String privateKeyPassword, String algorithm) throws OperatorCreationException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, (PrivateKey)sdfPrivateKey);
        return GMSSLP10Utils.generateP10(subject, contentSigner, publicKey);
    }

    public static PKCS10CertificationRequest generateP10SignByPcie(String subject, PublicKey publicKey, int privateKeyIndex, String privateKeyPassword, String algorithm) throws OperatorCreationException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(algorithm, (PrivateKey)sdfPrivateKey);
        return GMSSLP10Utils.generateP10(subject, contentSigner, publicKey);
    }

    public static PKCS10CertificationRequest generateP10(String subject, ContentSigner contentSigner, PublicKey publicKey) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(subject), publicKey);
        PKCS10CertificationRequest pkcs10 = requestBuilder.build(contentSigner);
        return pkcs10;
    }

    public static byte[] encodeP10(PKCS10CertificationRequest pkcs10CertificationRequest) throws IOException {
        return pkcs10CertificationRequest.getEncoded();
    }

    public static PKCS10CertificationRequest decodeP10(String base64P10) throws IOException {
        return new PKCS10CertificationRequest(GMSSLByteArrayUtils.base64Decode((String)base64P10));
    }

    public static PKCS10CertificationRequest decodeP10(byte[] p10) throws IOException {
        return new PKCS10CertificationRequest(p10);
    }

    public static PKCS10CertificationRequest decodeP10VerifyByBC(String base64P10) throws IOException {
        PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.decodeP10(GMSSLByteArrayUtils.base64Decode((String)base64P10));
        GMSSLP10Utils.decodeP10VerifyByBC(pkcs10CertificationRequest);
        return new PKCS10CertificationRequest(GMSSLByteArrayUtils.base64Decode((String)base64P10));
    }

    public static PKCS10CertificationRequest decodeP10VerifyByBC(byte[] p10) throws IOException {
        PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.decodeP10(p10);
        GMSSLP10Utils.decodeP10VerifyByBC(pkcs10CertificationRequest);
        return new PKCS10CertificationRequest(p10);
    }

    private static void decodeP10VerifyByBC(PKCS10CertificationRequest pkcs10CertificationRequest) throws IOException {
        boolean verify;
        SubjectPublicKeyInfo subjectPublicKeyInfo = pkcs10CertificationRequest.getSubjectPublicKeyInfo();
        try {
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(subjectPublicKeyInfo);
            verify = pkcs10CertificationRequest.isSignatureValid(verifierProvider);
        }
        catch (OperatorCreationException | PKCSException e) {
            throw new IOException("verify error", e);
        }
        if (!verify) {
            logger.info("pkcs10 verify={}", (Object)verify);
            throw new IOException("can not verify");
        }
    }

    public static PKCS10CertificationRequest decodeP10VerifyByYunhsm(String base64P10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLP10Utils.decodeP10VerifyBySDF(SdfCryptoType.YUNHSM, GMSSLByteArrayUtils.base64Decode((String)base64P10));
    }

    public static PKCS10CertificationRequest decodeP10VerifyByYunhsm(byte[] p10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLP10Utils.decodeP10VerifyBySDF(SdfCryptoType.YUNHSM, p10);
    }

    public static PKCS10CertificationRequest decodeP10VerifyByPCIE(String base64P10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLP10Utils.decodeP10VerifyBySDF(SdfCryptoType.PCIE, GMSSLByteArrayUtils.base64Decode((String)base64P10));
    }

    public static PKCS10CertificationRequest decodeP10VerifyByPCIE(byte[] p10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLP10Utils.decodeP10VerifyBySDF(SdfCryptoType.PCIE, p10);
    }

    public static PKCS10CertificationRequest decodeP10VerifyBySDF(SdfCryptoType sdfCryptoType, String base64P10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.decodeP10(base64P10);
        GMSSLP10Utils.decodeP10VerifyBySDF(pkcs10CertificationRequest, sdfCryptoType);
        return new PKCS10CertificationRequest(GMSSLByteArrayUtils.base64Decode((String)base64P10));
    }

    public static PKCS10CertificationRequest decodeP10VerifyBySDF(SdfCryptoType sdfCryptoType, byte[] p10) throws IOException, SdfSDKException, InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.decodeP10(p10);
        GMSSLP10Utils.decodeP10VerifyBySDF(pkcs10CertificationRequest, sdfCryptoType);
        return new PKCS10CertificationRequest(p10);
    }

    private static void decodeP10VerifyBySDF(PKCS10CertificationRequest pkcs10CertificationRequest, final SdfCryptoType sdfCryptoType) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, SdfSDKException {
        boolean verify;
        SubjectPublicKeyInfo subjectPublicKeyInfo = pkcs10CertificationRequest.getSubjectPublicKeyInfo();
        final PublicKey publicKey = GMSSLX509Utils.convertSM2PublicKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
        ContentVerifierProvider provider = new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                return GMSSLContentVerifierUtils.generateContentVerifierBySdf(sdfCryptoType, algorithm, publicKey);
            }
        };
        try {
            verify = pkcs10CertificationRequest.isSignatureValid(provider);
        }
        catch (PKCSException e) {
            throw new SdfSDKException("verify error", (Throwable)e);
        }
        if (!verify) {
            throw new IOException("can not verify");
        }
    }

    public static void writeP10ToFile(String path, String name, Object object) throws Exception {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filename = path + File.separator + name + ".p10";
        FileWriter writer = new FileWriter(filename);
        GMSSLX509Utils.writePEM((Object)object, (Writer)writer);
        writer.close();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

