/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils.bean;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public enum GMSSLSignatureAlgorithm {
    SM3_WITH_SM2(GMObjectIdentifiers.sm2sign_with_sm3, "SM3WITHSM2"),
    SHA1_WITH_RSA(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA"),
    SHA1_WITH_ECDSA(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA"),
    SHA256_WITH_RSA(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA"),
    SHA512_WITH_RSA(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA"),
    SHA256_WITH_ECDSA(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");

    private ASN1ObjectIdentifier aid;
    private String sigAlgName;

    public ASN1ObjectIdentifier getAid() {
        return this.aid;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    private GMSSLSignatureAlgorithm(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public AlgorithmIdentifier convertAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlgName);
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(String algorithm) {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        return GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(ASN1ObjectIdentifier aid) {
        if (aid.getId().equalsIgnoreCase(GMObjectIdentifiers.sm2sign_with_sm3.getId())) {
            return SM3_WITH_SM2;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return SHA1_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return SHA256_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId())) {
            return SHA512_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(X9ObjectIdentifiers.ecdsa_with_SHA256.getId())) {
            return SHA256_WITH_ECDSA;
        }
        return null;
    }
}

