package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLCipherUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import org.bouncycastle.crypto.InvalidCipherTextException;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.security.*;

/**
 * @author sxy
 * @description
 * @date 2019年09月18日 15:57
 **/
public class GMSSLRSAEncryptUtils {

    /************************************************************************************
     *                                      NoPadding                                  *
     ************************************************************************************/
    /**
     * 使用BC软算法对数据进行加密
     * NOPadding
     * @param publicKey 公钥
     * @param data 代加密数据 base64编码
     * @return 加密数据 base64编码
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static String encryptDataByBC(
            PublicKey publicKey, String data
    ) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode(data);
        byte[] cipher = GMSSLRSAUtils.encryptData(publicKey, plain);
        return GMSSLByteArrayUtils.base64Encode(cipher);
    }

    /**
     * 使用BC软算法对数据进行解密
     * NoPadding
     * @param privateKey 私钥
     * @param data 带解密数据 base64编码
     * @return 解密后的数据 base64编码
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static String decryptDataByBC(
            PrivateKey privateKey, String data
    ) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode(data);
        byte[] plain = GMSSLRSAUtils.decryptData(privateKey, cipher);
        return GMSSLByteArrayUtils.base64Encode(plain);
    }

    /**
     * 使用BC软算法对数据进行加密
     * NoPadding
     * @param publicKey 公钥
     * @param data 代加密数据
     * @return 加密数据 byte数组
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static byte[] encryptDataByBC(
            PublicKey publicKey, byte[] data
    ) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.encryptData(publicKey, data);
    }

    /**
     * 使用BC软算法对数据进行解密
     * NoPadding
     * @param privateKey 私钥
     * @param data 带解密数据
     * @return 解密后的数据 byte数组
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static byte[] decryptDataByBC(
            PrivateKey privateKey, byte[] data
    ) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.decryptData(privateKey, data);
    }

    /************************************************************************************
     *                                      PKCS1Padding                                  *
     ************************************************************************************/

    /**
     * 使用BC软算法对数据进行加密
     * PKCS1Padding
     * @param publicKey 公钥
     * @param data 代加密数据 base64编码
     * @return 加密数据 base64编码
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static String encryptDataPKCS1ByBC(
            PublicKey publicKey, String data
    ) throws InvalidCipherTextException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode(data);
        byte[] cipher = GMSSLRSAUtils.encryptDataPKCS1Padding(publicKey, plain);
        return GMSSLByteArrayUtils.base64Encode(cipher);
    }

    /**
     * 使用BC软算法对数据进行解密
     * PKCS1Padding
     * @param privateKey 私钥
     * @param data 带解密数据 base64编码
     * @return 解密后的数据 base64编码
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static String decryptDataPKCS1ByBC(
            PrivateKey privateKey, String data
    ) throws InvalidCipherTextException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode(data);
        byte[] plain = GMSSLRSAUtils.decryptDataPKCS1Padding(privateKey, cipher);
        return GMSSLByteArrayUtils.base64Encode(plain);
    }

    /**
     * 使用BC软算法对数据进行加密
     * PKCS1Padding
     * @param publicKey 公钥
     * @param data 代加密数据
     * @return 加密数据 byte数组
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static byte[] encryptDataPKCS1ByBC(
            PublicKey publicKey, byte[] data
    ) throws InvalidCipherTextException {
        return GMSSLRSAUtils.encryptDataPKCS1Padding(publicKey, data);
    }


    /**
     * 使用BC软算法对数据进行解密
     * PKCS1Padding
     * @param privateKey 私钥
     * @param data 带解密数据
     * @return 解密后的数据 byte数组
     * @throws NoSuchPaddingException
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     * @throws InvalidKeyException
     * @throws BadPaddingException
     * @throws IllegalBlockSizeException
     */
    public static byte[] decryptDataPKCS1ByBC(
            PrivateKey privateKey, byte[] data
    ) throws InvalidCipherTextException {
        return GMSSLRSAUtils.decryptDataPKCS1Padding(privateKey, data);
    }
}
