package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Provider;
import java.security.Security;


public class GMSSLSM4ECBEncryptUtils {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /**
     * 使用 BC 进行加密 NoPadding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 密文消息
     */
    public static String encryptByBCWithNoPadding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static byte[] encryptByBCWithNoPadding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding,
                key,
                data);
    }

    /**
     * 使用 BC 进行加密 PKCS5Padding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByBCWithPKCS5Padding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static byte[] encryptByBCWithPKCS5Padding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding,
                key,
                data);
    }

    /**
     * 使用 BC 进行加密 PKCS7Padding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByBCWithPKCS7Padding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static byte[] encryptByBCWithPKCS7Padding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(true,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding,
                key,
                data);
    }

    /**
     * 使用 BC 进行解密 NoPadding填充
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 密文消息
     */
    public static String decryptByBCWithNoPadding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static byte[] decryptByBCWithNoPadding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding,
                key,
                data);
    }

    /**
     * 使用 BC 进行加密 PKCS5Padding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 加密消息
     * @return BASE64 编码 密文消息
     */
    public static String decryptByBCWithPKCS5Padding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] decryptByBCWithPKCS5Padding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding,
                key,
                data);
    }

    /**
     * 使用 BC 进行加密 PKCS5Padding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 加密消息
     * @return BASE64 编码 密文消息
     */
    public static String decryptByBCWithPKCS7Padding(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] decryptByBCWithPKCS7Padding(byte[] key, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptByBC(false,
                GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding,
                key,
                data);
    }


    /**
     * 使用 加密机Yunhsm 进行加密 NoPadding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithNoPadding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByYumhsmWithNoPadding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                key,
                data);
    }


    /**
     * 使用 加密机Yunhsm 进行加密 PKCS5Padding填充
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithPKCS5Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByYumhsmWithPKCS5Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行加密 PKCS7Padding填充
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithPKCS7Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByYumhsmWithPKCS7Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行加密 SSL3Padding填充
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithSSL3Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByYumhsmWithSSL3Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行解密 NoPadding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithNoPadding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByYumhsmWithNoPadding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行解密 PKCS5Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithPKCS5Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByYumhsmWithPKCS5Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行解密 PKCS7Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithPKCS7Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByYumhsmWithPKCS7Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                key,
                data);
    }

    /**
     * 使用 加密机Yunhsm 进行解密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithSSL3Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByYumhsmWithSSL3Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                key,
                data);
    }

    /**
     * 使用 PCIE 进行加密 NoPadding填充  传入明文为16整数倍
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithNoPadding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByPcieWithNoPadding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                key,
                data);
    }

    /**
     * 使用 PCIE 进行加密 PKCS5Padding
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithPKCS5Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByPcieWithPKCS5Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                key,
                data);
    }

    /**
     * 使用 PCIE 进行加密 PKCS7Padding
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithPKCS7Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByPcieWithPKCS7Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                key,
                data);
    }

    /**
     * 使用 PCIE 进行加密 SSL3Padding填充
     *
     * @param base64Key  BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data BASE64 编码 待加密消息
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithSSL3Padding(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }
    public static byte[] encryptByPcieWithSSL3Padding(byte[] key, byte[] data) throws Exception {
        return sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                key,
                data);
    }

    /**
     * 使用 PCIE 进行解密  NoPadding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithNoPadding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByPcieWithNoPadding(byte[] key, byte[] cipher) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                key,
                cipher);
    }

    /**
     * 使用 PCIE 进行解密 PKCS5Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithPKCS5Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByPcieWithPKCS5Padding(byte[] key, byte[] cipher) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                key,
                cipher);
    }

    /**
     * 使用 PCIE 进行解密 PKCS7Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithPKCS7Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByPcieWithPKCS7Padding(byte[] key, byte[] cipher) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                key,
                cipher);
    }

    /**
     * 使用 PCIE 进行解密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithSSL3Padding(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }
    public static byte[] decryptByPcieWithSSL3Padding(byte[] key, byte[] cipher) throws Exception {
        return sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                key,
                cipher);
    }

    /**
     * 使用 padding模式填充的加解密公用类
     *
     * @param forEncryption 是否为加密
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           16位byte[] 会话密钥
     * @param data          二进制byte[]数据 待加密消息或已加密消息
     * @return BASE64 编码 明文消息
     */
    public static byte[] sm4SymmetricWithPaddingByPCIE(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType,
                                                       byte[] key, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(forEncryption, SdfCryptoType.PCIE,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM4_ECB, data);

    }

    /**
     * 使用 padding模式填充的加解密公用类 加密机YumHsm
     *
     * @param forEncryption 是否为加密
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           16位byte[] 会话密钥
     * @param data          二进制byte[]数据 待加密消息或已加密消息
     * @return BASE64 编码 明文消息
     */
    public static byte[] sm4SymmetricWithPaddingByYunHsm(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType,
                                                         byte[] key, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(forEncryption, SdfCryptoType.YUNHSM,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM4_ECB, data);

    }

    /**
     * 使用 padding模式填充的加解密公用类
     *
     * @param forEncryption 是否为加密
     * @param sdfCryptoType 加密使用类型 包括加密机YumHsm和PCIE卡
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           16位byte[] 会话密钥
     * @param data          二进制byte[]数据 待加密消息或已加密消息
     * @return BASE64 编码 明文消息
     */
    public static byte[] sm4SymmetricSdfWithPadding(boolean forEncryption, SdfCryptoType sdfCryptoType,
                                                    SdfSymmetricKeyParameters.PaddingType paddingType,
                                                    byte[] key, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(forEncryption, sdfCryptoType,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM4_ECB, data);

    }
}
