/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class GMSSLRSAEncryptUtils {
    public static String encryptDataByBC(PublicKey publicKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] cipher = GMSSLRSAUtils.encryptData((PublicKey)publicKey, (byte[])plain);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static String decryptDataByBC(PrivateKey privateKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] plain = GMSSLRSAUtils.decryptData((PrivateKey)privateKey, (byte[])cipher);
        return GMSSLByteArrayUtils.base64Encode((byte[])plain);
    }

    public static byte[] encryptDataByBC(PublicKey publicKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.encryptData((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decryptDataByBC(PrivateKey privateKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.decryptData((PrivateKey)privateKey, (byte[])data);
    }

    public static String encryptDataPKCS1ByBC(PublicKey publicKey, String data) throws InvalidCipherTextException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] cipher = GMSSLRSAUtils.encryptDataPKCS1Padding((PublicKey)publicKey, (byte[])plain);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static String decryptDataPKCS1ByBC(PrivateKey privateKey, String data) throws InvalidCipherTextException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] plain = GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)privateKey, (byte[])cipher);
        return GMSSLByteArrayUtils.base64Encode((byte[])plain);
    }

    public static byte[] encryptDataPKCS1ByBC(PublicKey publicKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.encryptDataPKCS1Padding((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decryptDataPKCS1ByBC(PrivateKey privateKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)privateKey, (byte[])data);
    }
}

