/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSHA256DigestUtils {
    public static String digestByBC(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSHA256DigestUtils.digestByBC(GMSSLByteArrayUtils.base64Decode((String)data)));
    }

    public static byte[] digestByBC(byte[] data) throws Exception {
        MessageDigest instance = MessageDigest.getInstance("SHA-256", "BC");
        return instance.digest(data);
    }

    public static String digestByYunHsm(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSHA256DigestUtils.digestByYunHsm(GMSSLByteArrayUtils.base64Decode((String)data)));
    }

    public static byte[] digestByYunHsm(byte[] data) throws Exception {
        SdfSHADigest sdfSHADigest = new SdfSHADigest(SdfAlgIdHash.SGD_SHA256);
        sdfSHADigest.update(data, 0, data.length);
        byte[] digest = new byte[sdfSHADigest.getDigestSize()];
        sdfSHADigest.doFinal(digest, 0);
        return digest;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

