/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM1Engine;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSM1BlockCipherUtils {
    public static String encryptByYunhsm(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM1BlockCipherUtils.sm1EngineBySdf(true, SdfCryptoType.YUNHSM, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static String decryptByYunhsm(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM1BlockCipherUtils.sm1EngineBySdf(false, SdfCryptoType.YUNHSM, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static String encryptByPcie(String base64Key, String base64Data) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM1BlockCipherUtils.sm1EngineBySdf(true, SdfCryptoType.PCIE, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static String decryptByPcie(String base64Key, String base64Cipher) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM1BlockCipherUtils.sm1EngineBySdf(false, SdfCryptoType.PCIE, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] sm1EngineByYunHsm(boolean forEncryption, byte[] key, byte[] data) throws SdfSDKException {
        return GMSSLSM1BlockCipherUtils.sm1EngineBySdf(forEncryption, SdfCryptoType.YUNHSM, key, data);
    }

    public static byte[] sm1EngineByPCIE(boolean forEncryption, byte[] key, byte[] data) throws SdfSDKException {
        return GMSSLSM1BlockCipherUtils.sm1EngineBySdf(forEncryption, SdfCryptoType.PCIE, key, data);
    }

    public static byte[] sm1EngineBySdf(boolean forEncryption, SdfCryptoType sdfCryptoType, byte[] key, byte[] data) throws SdfSDKException {
        SdfSM1Engine sdfSM1Engine = new SdfSM1Engine(sdfCryptoType);
        byte[] out = new byte[data.length];
        KeyParameter param = new KeyParameter(key);
        sdfSM1Engine.init(forEncryption, (CipherParameters)param);
        sdfSM1Engine.processBlock(data, 0, out, 0);
        sdfSM1Engine.release();
        return out;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

