/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentVerifierProviderUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLSdfSM2SignerUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;

public class GMSSLSM2SignUtils {
    public static String signByBC(PrivateKey privateKey, String base64Data) throws CryptoException, IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sig = GMSSLSM2SignUtils.signByBC(privateKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])sig);
    }

    public static byte[] signByBC(PrivateKey privateKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        SM2Signer signer = new SM2Signer();
        signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, new SecureRandom()));
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public static String signByYunhsm(int privateKeyIndex, String privateKeyPassword, String base64Data) throws CryptoException, SdfSDKException {
        return GMSSLSM2SignUtils.signBySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String signByPcie(int privateKeyIndex, String privateKeyPassword, String base64Data) throws CryptoException, SdfSDKException {
        return GMSSLSM2SignUtils.signBySdf(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data) throws CryptoException, SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sig = GMSSLSM2SignUtils.signBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])sig);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] data) throws CryptoException, SdfSDKException {
        return GMSSLSM2SignUtils.signBySdf(sdfCryptoType, null, privateKeyIndex, privateKeyPassword, data);
    }

    public static byte[] signBySdfWithUserId(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] userId, byte[] data) throws CryptoException, SdfSDKException {
        return GMSSLSM2SignUtils.signBySdf(sdfCryptoType, userId, privateKeyIndex, privateKeyPassword, data);
    }

    public static boolean verifyByBC(PublicKey publicKey, String base64Data, String base64Sign) throws IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLSM2SignUtils.verifyByBC(publicKey, data, sign);
    }

    public static boolean verifyByBC(PublicKey publicKey, byte[] data, byte[] sign) throws IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)keyParameter);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    public static boolean verifyByYunhsm(PublicKey publicKey, String base64Data, String base64Sign) throws SdfSDKException {
        return GMSSLSM2SignUtils.verifyBySdf(SdfCryptoType.YUNHSM, publicKey, base64Data, base64Sign);
    }

    public static boolean verifyByPcie(PublicKey publicKey, String base64Data, String base64Sign) throws SdfSDKException {
        return GMSSLSM2SignUtils.verifyBySdf(SdfCryptoType.PCIE, publicKey, base64Data, base64Sign);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data, String base64Sign) throws SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLSM2SignUtils.verifyBySdf(sdfCryptoType, publicKey, data, sign);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        return GMSSLSM2SignUtils.verifyBySdf(sdfCryptoType, null, publicKey, data, sign);
    }

    public static boolean verifyBySdfWithUserId(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] userId, byte[] data, byte[] sign) throws SdfSDKException {
        return GMSSLSM2SignUtils.verifyBySdf(sdfCryptoType, userId, publicKey, data, sign);
    }

    public static boolean verifyCertByYunHsm(X509Certificate cert, PublicKey publicKey) throws Exception {
        try {
            Certificate certificate = GMSSLX509Utils.convertCertificate((X509Certificate)cert);
            return GMSSLSM2SignUtils.verify(certificate.getSignatureAlgorithm(), publicKey, certificate.getTBSCertificate().getEncoded(), certificate.getSignature().getOctets());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public static boolean verify(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey, byte[] encoded, byte[] expected) throws Exception {
        ContentVerifierProvider verifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(SdfCryptoType.YUNHSM, publicKey);
        ContentVerifier verifier = verifierProvider.get(algorithmIdentifier);
        OutputStream out = verifier.getOutputStream();
        out.write(encoded);
        out.close();
        return verifier.verify(expected);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data) throws CryptoException, SdfSDKException {
        SdfECBaseSigner signer = GMSSLSdfSM2SignerUtils.generateSM2Signer(sdfCryptoType);
        return GMSSLSM2SignUtils.signBySdf(signer, userId, privateKeyIndex, privateKeyPassword, data);
    }

    public static byte[] signBySdfHSM(SdfCryptoType sdfCryptoType, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data) throws CryptoException, SdfSDKException {
        SdfECSigner signer = new SdfECSigner(sdfCryptoType);
        return GMSSLSM2SignUtils.signBySdf((SdfECBaseSigner)signer, userId, privateKeyIndex, privateKeyPassword, data);
    }

    public static byte[] signBySdf(SdfECBaseSigner signer, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data) throws CryptoException, SdfSDKException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        SdfECKeyParameters sdfECKeyParameters = new SdfECKeyParameters(sdfPrivateKey);
        Object parameters = userId != null ? new ParametersWithID((CipherParameters)sdfECKeyParameters, userId) : sdfECKeyParameters;
        signer.init(true, (CipherParameters)parameters);
        signer.update(data, 0, data.length);
        byte[] signature = signer.generateSignature();
        signer.release();
        return signature;
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        SdfSM2SignerSM3 signer = new SdfSM2SignerSM3(sdfCryptoType);
        return GMSSLSM2SignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyByHSM(SdfCryptoType sdfCryptoType, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        SdfECSigner signer = new SdfECSigner(sdfCryptoType);
        return GMSSLSM2SignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyBySdf(SdfECBaseSigner signer, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        SdfECKeyParameters sdfECKeyParameters = new SdfECKeyParameters((ECPublicKey)publicKey);
        Object parameters = userId != null ? new ParametersWithID((CipherParameters)sdfECKeyParameters, userId) : sdfECKeyParameters;
        signer.init(false, (CipherParameters)parameters);
        signer.update(data, 0, data.length);
        boolean isVerify = signer.verifySignature(sign);
        signer.release();
        return isVerify;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

