/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancDigestPreProcessUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.operator.utils.GMSSLSdfSM2SignerUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLECSignUtils {
    public static byte[] sign(PrivateKey privateKey, byte[] data, byte[] userId, String signAlgName) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivateKey = (SdfPrivateKey)privateKey;
                return GMSSLECSignUtils.signBySdf(SdfCryptoType.PCIE, userId, pciePrivateKey.getIndex(), pciePrivateKey.getStringPassword(), data, signAlgName);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivateKey = (SdfPrivateKey)privateKey;
                return GMSSLECSignUtils.signBySdf(SdfCryptoType.YUNHSM, userId, hsmPrivateKey.getIndex(), hsmPrivateKey.getStringPassword(), data, signAlgName);
            }
            case MINI_PCI_E: {
                SdfPrivateKey miniPciePrivateKey = (SdfPrivateKey)privateKey;
                return GMSSLECSignUtils.signByMiniPcie(miniPciePrivateKey.getIndex(), miniPciePrivateKey.getStringPassword(), data, signAlgName);
            }
            case SANC_HSM: {
                return GMSSLECSignUtils.signBySancHsm(privateKey, data, userId, signAlgName);
            }
        }
        return GMSSLBCSignUtils.generateSignature((String)signAlgName, (PrivateKey)privateKey, (byte[])data);
    }

    public static boolean verify(PublicKey publicKey, byte[] data, byte[] signature, byte[] userId, String signAlgName) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.PCIE, userId, publicKey, data, signature, signAlgName);
            }
            case XDJA_HSM: {
                return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.YUNHSM, userId, publicKey, data, signature, signAlgName);
            }
            case MINI_PCI_E: {
                return GMSSLECSignUtils.verifyByMiniPcie(publicKey, data, signature, signAlgName);
            }
            case SANC_HSM: {
                return GMSSLECSignUtils.verifyBySancHsm(publicKey, data, signature, userId, signAlgName);
            }
        }
        if (null != userId && signAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            return GMSSLBCSignUtils.sm2VerifyWithUserId((PublicKey)publicKey, (byte[])userId, (byte[])data, (byte[])signature);
        }
        return GMSSLBCSignUtils.verifySignature((String)signAlgName, (PublicKey)publicKey, (byte[])data, (byte[])signature);
    }

    private static byte[] signBySancHsm(PrivateKey privateKey, byte[] data, byte[] userId, String signAlgName) throws Exception {
        SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        if (signAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            SM2refPublicKey sm2PublicKey = cryptConnection.getSM2PublicKey(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.SIGN.getKeyType());
            byte[] sm3Digest = GMSSLSancDigestPreProcessUtils.sm3Digest(GMSSLSancConverUtils.converSM2PublicKey(sm2PublicKey), data, userId);
            SM2refSignature sm2refSignature = cryptConnection.sm2Sign(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.SIGN.getKeyType(), sm3Digest);
            return GMSSLSancConverUtils.converSM2Signature(sm2refSignature);
        }
        throw new IllegalArgumentException("sanc hsm interface un support the signAlgName " + signAlgName);
    }

    private static boolean verifyBySancHsm(PublicKey publicKey, byte[] data, byte[] signature, byte[] userId, String signAlgName) throws Exception {
        if (signAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            byte[] sm3Digest = GMSSLSancDigestPreProcessUtils.sm3Digest(publicKey, data, userId);
            SM2refSignature sm2refSignature = GMSSLSancConverUtils.converSM2RefSignature(signature);
            return GMSSLSancConnectionUtils.getCryptConnection().sm2Verify(GMSSLSancConverUtils.converSM2RefPublicKey(publicKey), sm3Digest, sm2refSignature);
        }
        throw new IllegalArgumentException("sanc hsm interface un support the signAlgName " + signAlgName);
    }

    public static byte[] signByMiniPcie(int index, String password, byte[] data, String signAlgName) throws Exception {
        if (signAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            return MiniPcieXKFUtils.sm2SignWithInternalHash((byte[])data, (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignPrivateIndex(), (String)password);
        }
        throw new IllegalArgumentException("mini pcie card interface un support the signAlgName " + signAlgName);
    }

    public static boolean verifyByMiniPcie(PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        if (signAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            Sm2PublicKey sm2PublicKey = new Sm2PublicKey(publicKey);
            return MiniPcieXKFUtils.sm2VerifyWithInternalHash((byte[])data, (byte[])sign, (Sm2PublicKey)sm2PublicKey);
        }
        throw new IllegalArgumentException("mini pcie card interface un support the signAlgName " + signAlgName);
    }

    public static String signByBC(PrivateKey privateKey, String base64Data, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sig = GMSSLECSignUtils.signByBC(privateKey, data, signAlgName);
        return GMSSLByteArrayUtils.base64Encode((byte[])sig);
    }

    public static byte[] signByBC(PrivateKey privateKey, byte[] data, String signAlgName) throws Exception {
        return GMSSLBCSignUtils.generateSignature((String)signAlgName, (PrivateKey)privateKey, (byte[])data);
    }

    public static boolean verifyByBC(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLECSignUtils.verifyByBC(publicKey, data, sign, signAlgName);
    }

    public static boolean verifyByBC(PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLBCSignUtils.verifySignature((String)signAlgName, (PublicKey)publicKey, (byte[])data, (byte[])sign);
    }

    public static String signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM ? GMSSLECSignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), data, null, signAlgName) : GMSSLECSignUtils.signBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, signAlgName);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static byte[] signByYunHsm(int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        return GMSSLECSignUtils.signBySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static boolean verifyByYunHsm(PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyByHSM(null, publicKey, data, sign, signAlgName);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        return GMSSLECSignUtils.signBySdf(sdfCryptoType, null, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signBySdfWithUserId(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] userId, byte[] data, String signAlgName) throws Exception {
        return GMSSLECSignUtils.signBySdf(sdfCryptoType, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static boolean verifyByYunHsm(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.YUNHSM, publicKey, base64Data, base64Sign, signAlgName);
    }

    public static boolean verifyByPcie(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.PCIE, publicKey, base64Data, base64Sign, signAlgName);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, publicKey, data, sign, signAlgName);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, null, publicKey, data, sign, signAlgName);
    }

    public static boolean verifyBySdfWithUserId(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] userId, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, userId, publicKey, data, sign, signAlgName);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLECSignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), data, userId, signAlgName);
        }
        SdfECBaseSigner signer = GMSSLSdfSM2SignerUtils.generateSM2Signer(sdfCryptoType, signAlgName);
        return GMSSLECSignUtils.signBySdf(signer, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signByYunHsm(byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLECSignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), data, userId, signAlgName);
        }
        SdfECSigner signer = new SdfECSigner(SdfCryptoType.YUNHSM, signAlgName);
        return GMSSLECSignUtils.signBySdf((SdfECBaseSigner)signer, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signBySdf(SdfECBaseSigner signer, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        return GMSSLSM2SignUtils.signBySdf(signer, userId, privateKeyIndex, privateKeyPassword, data);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLECSignUtils.verify(publicKey, data, sign, userId, signAlgName);
        }
        SdfSM2SignerSM3 signer = new SdfSM2SignerSM3(sdfCryptoType, signAlgName);
        return GMSSLECSignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyByHSM(byte[] userId, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLECSignUtils.verify(publicKey, data, sign, userId, signAlgName);
        }
        SdfECSigner signer = new SdfECSigner(SdfCryptoType.YUNHSM, signAlgName);
        return GMSSLECSignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyBySdf(SdfECBaseSigner signer, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        return GMSSLSM2SignUtils.verifyBySdf(signer, userId, publicKey, data, sign);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

