/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSASigner;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancDigestPreProcessUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.operator.utils.GMSSLPKCS1Encodeing;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public class GMSSLRSASignUtils {
    public static byte[] sign(PrivateKey privateKey, byte[] data, String signAlgorithm) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivateKey = (SdfPrivateKey)privateKey;
                return GMSSLRSASignUtils.signBySdf(SdfCryptoType.PCIE, signAlgorithm, pciePrivateKey.getIndex(), pciePrivateKey.getStringPassword(), data);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivateKey = (SdfPrivateKey)privateKey;
                return GMSSLRSASignUtils.signBySdf(SdfCryptoType.YUNHSM, signAlgorithm, hsmPrivateKey.getIndex(), hsmPrivateKey.getStringPassword(), data);
            }
            case SANC_HSM: {
                return GMSSLRSASignUtils.signBySancHsm(privateKey, data, signAlgorithm);
            }
        }
        return GMSSLRSASignUtils.signByBC(signAlgorithm, privateKey, data);
    }

    public static boolean verify(PublicKey publicKey, byte[] data, byte[] sign, String signAlgorithm) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.PCIE, signAlgorithm, publicKey, data, sign);
            }
            case XDJA_HSM: {
                return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.YUNHSM, signAlgorithm, publicKey, data, sign);
            }
            case SANC_HSM: {
                return GMSSLRSASignUtils.verifyBySancHsm(publicKey, data, sign, signAlgorithm);
            }
        }
        return GMSSLRSASignUtils.verifyByBC(signAlgorithm, publicKey, data, sign);
    }

    public static byte[] signBySancHsm(PrivateKey privateKey, byte[] data, String signAlgorithm) throws Exception {
        SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        byte[] digest = GMSSLRSASignUtils.sancPreProcess(data, signAlgorithm);
        IRSArefPublicKey rsaPublicKey = cryptConnection.getRSAPublicKey(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.SIGN.getKeyType());
        byte[] padding = GMSSLPKCS1Encodeing.encodePrivateBlock(digest, 0, digest.length, rsaPublicKey.getBits());
        byte[] endData = GMSSLByteArrayUtils.changeByteArrayLength((byte[])padding, (int)(rsaPublicKey.getBits() / 8));
        return cryptConnection.rsaPrivateKeyOperation(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.SIGN.getKeyType(), endData);
    }

    public static boolean verifyBySancHsm(PublicKey publicKey, byte[] data, byte[] sign, String signAlgorithm) throws Exception {
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        byte[] digest = GMSSLRSASignUtils.sancPreProcess(data, signAlgorithm);
        IRSArefPublicKey arefPublicKey = GMSSLSancConverUtils.converRSARefPublicKey(publicKey);
        byte[] operation = cryptConnection.rsaPublicKeyOperation(arefPublicKey, sign);
        byte[] normal = GMSSLPKCS1Encodeing.decodeBlock(operation, arefPublicKey.getBits());
        if (GMSSLByteArrayUtils.isEqual((byte[])normal, (byte[])digest)) {
            return true;
        }
        GMSSLByteArrayUtils.printHexBinary(null, (String)"operation", (byte[])operation);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"digest", (byte[])digest);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"normal", (byte[])normal);
        return false;
    }

    private static byte[] sancPreProcess(byte[] data, String signAlgorithm) throws Exception {
        byte[] digest;
        if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName())) {
            digest = GMSSLSancDigestPreProcessUtils.sha256Digest(data);
        } else if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName())) {
            digest = GMSSLSancDigestPreProcessUtils.sha1Digest(data);
        } else {
            throw new Exception("can't support the signAlgorithm " + signAlgorithm);
        }
        return digest;
    }

    public static String signByBC(String algorithm, PrivateKey privateKey, String data) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLRSAUtils.generateSignature((String)algorithm, (PrivateKey)privateKey, (byte[])dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static boolean verifyByBC(String algorithm, PublicKey publicKey, String data, String sign) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSAUtils.verifySignature((String)algorithm, (PublicKey)publicKey, (byte[])dataBytes, (byte[])signBytes);
    }

    public static byte[] signByBC(String algorithm, PrivateKey privateKey, byte[] data) throws Exception {
        return GMSSLRSAUtils.generateSignature((String)algorithm, (PrivateKey)privateKey, (byte[])data);
    }

    public static boolean verifyByBC(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        return GMSSLRSAUtils.verifySignature((String)algorithm, (PublicKey)publicKey, (byte[])data, (byte[])sign);
    }

    public static byte[] signByYunHsm(String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSASignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), data, algorithm);
        }
        return GMSSLRSASignUtils.signBySdf(SdfCryptoType.YUNHSM, algorithm, privateKeyIndex, privateKeyPassword, data);
    }

    public static String signByYunHsm(String algorithm, int privateKeyIndex, String privateKeyPassword, String data) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM ? GMSSLRSASignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), dataBytes, algorithm) : GMSSLRSASignUtils.signBySdf(SdfCryptoType.YUNHSM, algorithm, privateKeyIndex, privateKeyPassword, dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static byte[] signByPcie(String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        return GMSSLRSASignUtils.signBySdf(SdfCryptoType.PCIE, algorithm, privateKeyIndex, privateKeyPassword, data);
    }

    public static String signByPcie(String algorithm, int privateKeyIndex, String privateKeyPassword, String data) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLRSASignUtils.signBySdf(SdfCryptoType.PCIE, algorithm, privateKeyIndex, privateKeyPassword, dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static boolean verifyByYunHsm(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.YUNHSM, algorithm, publicKey, data, sign);
    }

    public static boolean verifyByYunHsm(String algorithm, PublicKey publicKey, String data, String sign) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.YUNHSM, algorithm, publicKey, dataBytes, signBytes);
    }

    public static boolean verifyByPcie(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.PCIE, algorithm, publicKey, data, sign);
    }

    public static boolean verifyByPcie(String algorithm, PublicKey publicKey, String data, String sign) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.PCIE, algorithm, publicKey, dataBytes, signBytes);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSASignUtils.sign((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), data, algorithm);
        }
        AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
        SdfRSASigner sdfRSASigner = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        SdfRSAKeyParameters rsaKeyParameters = new SdfRSAKeyParameters(sdfPrivateKey);
        sdfRSASigner.init(true, (CipherParameters)rsaKeyParameters);
        sdfRSASigner.update(data, 0, data.length);
        byte[] sign = sdfRSASigner.generateSignature();
        sdfRSASigner.release();
        return sign;
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSASignUtils.verify(publicKey, data, sign, algorithm);
        }
        AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
        SdfRSASigner sdfRSASigner = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
        SdfRSAKeyParameters rsaKeyParameter = new SdfRSAKeyParameters((RSAPublicKey)publicKey);
        sdfRSASigner.init(false, (CipherParameters)rsaKeyParameter);
        sdfRSASigner.update(data, 0, data.length);
        boolean verify = sdfRSASigner.verifySignature(sign);
        sdfRSASigner.release();
        return verify;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

