/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.util.BigIntegers;

public class GMSSLSancConverUtils {
    public static PublicKey converSM2PublicKey(SM2refPublicKey sm2refPublicKey) throws Exception {
        return GMSSLX509Utils.convertSM2PublicKey((byte[])sm2refPublicKey.getX(), (byte[])sm2refPublicKey.getY());
    }

    public static PrivateKey converSM2PrivateKey(SM2refPrivateKey sm2refPrivateKey) throws Exception {
        return GMSSLX509Utils.convertPrivateKeyEncode((byte[])sm2refPrivateKey.getD());
    }

    public static SM2refPublicKey converSM2RefPublicKey(PublicKey publicKey) {
        BCECPublicKey bcecPublicKey = (BCECPublicKey)publicKey;
        byte[] x = bcecPublicKey.getW().getAffineX().toByteArray();
        byte[] y = bcecPublicKey.getW().getAffineY().toByteArray();
        return new SM2refPublicKey(GMSSLByteArrayUtils.changeByteArrayLength((byte[])x, (int)32), GMSSLByteArrayUtils.changeByteArrayLength((byte[])y, (int)32));
    }

    public static SM2refPrivateKey converSM2RefPrivateKey(PrivateKey privateKey) throws Exception {
        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)privateKey;
        byte[] s = bcecPrivateKey.getD().toByteArray();
        return new SM2refPrivateKey(GMSSLByteArrayUtils.changeByteArrayLength((byte[])s, (int)32));
    }

    public static SM2refSignature converSM2RefSignature(byte[] signature) throws Exception {
        BigInteger[] bigIntegers = GMSSLX509Utils.derSignatureDecode((byte[])signature);
        assert (bigIntegers != null);
        byte[] r = GMSSLByteArrayUtils.changeByteArrayLength((byte[])bigIntegers[0].toByteArray(), (int)32);
        byte[] s = GMSSLByteArrayUtils.changeByteArrayLength((byte[])bigIntegers[1].toByteArray(), (int)32);
        return new SM2refSignature(r, s);
    }

    public static byte[] converSM2Signature(SM2refSignature refSignature) throws Exception {
        return GMSSLX509Utils.derSignatureEncode((byte[])refSignature.getR(), (byte[])refSignature.getS());
    }

    public static IRSArefPublicKey converRSARefPublicKey(PublicKey publicKey) throws Exception {
        BCRSAPublicKey rsaPublicKey = (BCRSAPublicKey)publicKey;
        RSArefPublicKeyLite rsArefPublicKeyLite = new RSArefPublicKeyLite();
        rsArefPublicKeyLite.bits = rsaPublicKey.getModulus().bitLength();
        rsArefPublicKeyLite.e = GMSSLByteArrayUtils.changeByteArrayLength((byte[])rsaPublicKey.getPublicExponent().toByteArray(), (int)256);
        rsArefPublicKeyLite.m = GMSSLByteArrayUtils.changeByteArrayLength((byte[])rsaPublicKey.getModulus().toByteArray(), (int)256);
        return rsArefPublicKeyLite;
    }

    public static PublicKey converRSAPublicKey(IRSArefPublicKey arefPublicKey) throws Exception {
        return GMSSLRSAUtils.convertRSAPublicKey((byte[])arefPublicKey.getM());
    }

    public static PrivateKey converRSAPrivateKey(IRSArefPrivateKey arefPrivateKey) throws Exception {
        return GMSSLRSAUtils.convertRSAPrivateKey((BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getM()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getE()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getD()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getPrime1()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getPrime2()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getPexp1()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getPexp2()), (BigInteger)BigIntegers.fromUnsignedByteArray((byte[])arefPrivateKey.getCoef()));
    }
}

