/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.utils.bc;

import com.xdja.pki.gmssl.asn1.x509.SubjectInformationAccess;
import com.xdja.pki.gmssl.x509.utils.bean.CRLEntry;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class X509CertUtils {
    public static KeyPair generateSM2KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC");
        kpGen.initialize(new ECGenParameterSpec("sm2p256v1"), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static X509Certificate generateCert(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey subjectKey, PrivateKey issuerKey, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        return X509CertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, issuerKey, extensions, ContentSignatureAlgorithm.SM3_WITH_SM2, ContentCryptoType.BC);
    }

    public static X509Certificate generateCert(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey subjectKey, PrivateKey issuerKey, List<Extension> extensions, ContentSignatureAlgorithm signatureAlgorithm, ContentCryptoType contentCryptoType) throws CertIOException, OperatorCreationException, CertificateException {
        return X509CertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, issuerKey, extensions, signatureAlgorithm, contentCryptoType);
    }

    private static X509Certificate generateCert(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey subjectKey, PrivateKey issuerKey, List<Extension> extensions, ContentSignatureAlgorithm signatureAlgorithm, ContentCryptoType contentCryptoType) throws CertIOException, OperatorCreationException, CertificateException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subjectKey.getEncoded());
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, subjectPublicKeyInfo);
        for (Extension extension : extensions) {
            builder.addExtension(extension);
        }
        ContentSigner contentSigner = X509CertUtils.genContentSigner(contentCryptoType, signatureAlgorithm, issuerKey);
        X509CertificateHolder holder = builder.build(contentSigner);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static X509CRL generateCRL(X509Certificate issueCert, PrivateKey issuerKey, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked) throws IOException, OperatorCreationException, CRLException {
        return X509CertUtils.generateCRL(issueCert, issuerKey, crlNumber, thisUpdate, nextUpdate, extensions, revoked, ContentCryptoType.BC, ContentSignatureAlgorithm.SM3_WITH_SM2);
    }

    public static X509CRL generateCRL(X509Certificate issueCert, PrivateKey issuerKey, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, ContentCryptoType contentCryptoType, ContentSignatureAlgorithm signatureAlgorithm) throws IOException, OperatorCreationException, CRLException {
        X509v2CRLBuilder builder = new X509v2CRLBuilder(new X500Name(issueCert.getSubjectDN().getName()), thisUpdate);
        builder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(crlNumber));
        builder.setNextUpdate(nextUpdate);
        for (Extension extension : extensions) {
            builder.addExtension(extension);
        }
        if (revoked != null) {
            for (CRLEntry entry : revoked) {
                builder.addCRLEntry(new BigInteger(entry.getUserCertificateSerial(), 16), entry.getRevocationDate(), entry.getReason());
            }
        }
        ContentSigner contentSigner = X509CertUtils.genContentSigner(contentCryptoType, signatureAlgorithm, issuerKey);
        X509CRLHolder crlHolder = builder.build(contentSigner);
        return new JcaX509CRLConverter().setProvider("BC").getCRL(crlHolder);
    }

    public static PKCS10CertificationRequest generateP10(String subject, PublicKey publicKey, PrivateKey privateKey) throws OperatorCreationException {
        return X509CertUtils.generateP10(subject, ContentCryptoType.BC, ContentSignatureAlgorithm.SM3_WITH_SM2, publicKey, privateKey);
    }

    public static PKCS10CertificationRequest generateP10(String subject, ContentCryptoType contentCryptoType, ContentSignatureAlgorithm signatureAlgorithm, PublicKey publicKey, PrivateKey privateKey) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(subject), publicKey);
        ContentSigner contentSigner = X509CertUtils.genContentSigner(contentCryptoType, signatureAlgorithm, privateKey);
        return requestBuilder.build(contentSigner);
    }

    public static byte[] encodeP10(PKCS10CertificationRequest pkcs10CertificationRequest) throws IOException {
        return pkcs10CertificationRequest.getEncoded();
    }

    public static PKCS10CertificationRequest decodeP10(byte[] p10) throws IOException {
        return new PKCS10CertificationRequest(p10);
    }

    public static ContentSigner genContentSigner(ContentCryptoType contentCryptoType, ContentSignatureAlgorithm signatureAlgorithm, PrivateKey privateKey) throws OperatorCreationException {
        switch (contentCryptoType) {
            case BC: {
                JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm.getId());
                return contentSignerBuilder.build(privateKey);
            }
            case PCIE: {
                throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
            }
            case YUNHSM: {
                throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
            }
        }
        throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
    }

    public static ContentSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getAlgorithm() == GMObjectIdentifiers.sm2sign_with_sm3) {
            return ContentSignatureAlgorithm.SM3_WITH_SM2;
        }
        return null;
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(ContentSignatureAlgorithm signatureAlgorithm) {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm.getId());
    }

    public static ContentVerifier genContentVerifier(ContentCryptoType contentCryptoType, ContentSignatureAlgorithm signatureAlgorithm, PublicKey publicKey) throws OperatorCreationException {
        return X509CertUtils.genContentVerifier(contentCryptoType, X509CertUtils.convertAlgorithmIdentifier(signatureAlgorithm), publicKey);
    }

    public static ContentVerifier genContentVerifier(ContentCryptoType contentCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        switch (contentCryptoType) {
            case BC: {
                ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
                return verifierProvider.get(algorithmIdentifier);
            }
            case PCIE: {
                throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
            }
            case YUNHSM: {
                throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
            }
        }
        throw new OperatorCreationException("un support crypto type " + (Object)((Object)contentCryptoType));
    }

    public static Extension genAuthorityInfoAccessExtension(String ldapUrl) throws IOException {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        AuthorityInformationAccess issueInfo = new AuthorityInformationAccess(new AccessDescription(AccessDescription.id_ad_caIssuers, new GeneralName(6, (ASN1Encodable)instance)));
        return new Extension(Extension.authorityInfoAccess, true, issueInfo.getEncoded());
    }

    public static Extension genSubjectInfoAccessExtension(String ldapUrl) throws IOException {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        SubjectInformationAccess subjectInfo = new SubjectInformationAccess(new AccessDescription(SubjectInformationAccess.id_ad_caRepository, new GeneralName(6, (ASN1Encodable)instance)));
        return new Extension(Extension.subjectInfoAccess, true, subjectInfo.getEncoded());
    }

    public static Extension genRootCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(6);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genSignatureCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(192);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genOCSPCertExtendedKeyUsageExtension() throws IOException {
        return new Extension(Extension.extendedKeyUsage, true, new ExtendedKeyUsage(KeyPurposeId.id_kp_OCSPSigning).getEncoded());
    }

    public static Extension genEncryptCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(56);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genAuthorityKeyIdentifierExtension(X509Certificate rootCert) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(rootCert);
        return new Extension(Extension.authorityKeyIdentifier, false, authorityKeyIdentifier.getEncoded());
    }

    public static Extension genSubjectKeyIdentifierExtension(PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(publicKey);
        return new Extension(Extension.subjectKeyIdentifier, false, subjectKeyIdentifier.getEncoded());
    }

    public static Extension genBasicConstraintsExtension(int pathLenConstraint) throws IOException {
        return new Extension(Extension.basicConstraints, true, new BasicConstraints(pathLenConstraint).getEncoded());
    }

    public static Extension genCRLDistributionPointsExtension(String crlLdapUrl) throws IOException {
        DistributionPointName dpn = X509CertUtils.genDistributionPointName(crlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.cRLDistributionPoints, true, crlDistPoint.getEncoded());
    }

    public static Extension genFreshestCRL(String crlLdapUrl) throws IOException {
        DistributionPointName dpn = X509CertUtils.genDistributionPointName(crlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.freshestCRL, true, crlDistPoint.getEncoded());
    }

    public static Extension genARLExtension(String arlLdapUrl) throws IOException {
        DistributionPointName dpn = X509CertUtils.genDistributionPointName(arlLdapUrl);
        ReasonFlags reasonFlags = new ReasonFlags(32);
        IssuingDistributionPoint point = new IssuingDistributionPoint(dpn, true, true, reasonFlags, true, true);
        return new Extension(Extension.issuingDistributionPoint, true, point.getEncoded());
    }

    public static Extension genDRLExtension(int drlNumber) throws IOException {
        CRLNumber basecrlnum = new CRLNumber(BigInteger.valueOf(drlNumber));
        return new Extension(Extension.deltaCRLIndicator, true, basecrlnum.getEncoded());
    }

    public static DistributionPointName genDistributionPointName(String ldapUrl) {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        GeneralName gn = new GeneralName(6, (ASN1Encodable)instance);
        GeneralNames gns = new GeneralNames(gn);
        return new DistributionPointName(0, (ASN1Encodable)gns);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static enum ContentCryptoType {
        BC("bc"),
        PCIE("pcie"),
        YUNHSM("yunhsm");

        private String id;

        public String getId() {
            return this.id;
        }

        private ContentCryptoType(String id) {
            this.id = id;
        }
    }

    public static enum ContentSignatureAlgorithm {
        SM3_WITH_SM2("SM3withSM2");

        private String id;

        public String getId() {
            return this.id;
        }

        private ContentSignatureAlgorithm(String id) {
            this.id = id;
        }

        private ContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        }
    }
}

