package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.SDSCryptoFactory;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;

import java.io.File;


/**
 * @description: 三未信安密码机相关工具类
 * @author: feng zhen
 * @date: 2020/6/1 16:12
 **/
public class GMSSLSancConnectionUtils {
    private static SDSCryptoFactory sdsCryptoFactory = new SDSCryptoFactory();

    /**
     * 连接到密码机并创建连接池
     *
     * @throws CryptoException
     */
    public static void init() throws CryptoException {
        String path = GMSSLSancHsmUtils.getConfPath(false) + File.separator + "swsds.ini";
        init(path);
    }

    public static void init(String configPath) throws CryptoException {
        sdsCryptoFactory.getInstance(GMSSLFileUtils.getResourceAsPath(configPath));
    }

    /**
     * 获取到加密使用的连接
     *
     * @throws CryptoException
     */
    public static ISDSCrypto getCryptConnection() throws CryptoException {
        return sdsCryptoFactory.getInstance();
    }

    /**
     * 释放密码机连接
     */
    public static void releaseConnection() {
        SDSCryptoFactory.releaseInstance();
    }

    /**
     * 使用新的配置重新初始化
     */
    public static void reInit(String configPath) throws Exception {
        releaseConnection();
        init(configPath);
    }
}
