package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.operator.utils.GMSSLXkfContentVerifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

import java.security.PublicKey;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/6/3 10:59
 **/
public class GMSSLSancContentVerifierProvider implements ContentVerifierProvider {
    private PublicKey publicKey;

    public GMSSLSancContentVerifierProvider(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public boolean hasAssociatedCertificate() {
        return false;
    }

    @Override
    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    @Override
    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        try {
            return new GMSSLSancContentVerifier(verifierAlgorithmIdentifier, publicKey);
        } catch (Exception e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }
}
