package com.xdja.pki.gmssl.operator.utils;


import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.*;

import java.io.OutputStream;
import java.security.*;


/**
 * @ClassName GMSSLXkfContentSigner
 * @Description TODO
 * @Date 2020/5/21 11:45
 * @Author FengZhen
 */
public class GMSSLXkfContentSigner implements ContentSigner {

    private GMSSLXkfSignatureOutputStream stream;
    private AlgorithmIdentifier sigAlgId;

    public GMSSLXkfContentSigner(String signatureAlgorithm, PrivateKey privateKey, boolean isWithParam) {
        this.sigAlgId = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(signatureAlgorithm, isWithParam);
        SdfPrivateKey sdfPrivateKey = (SdfPrivateKey) privateKey;
        this.stream = new GMSSLXkfSignatureOutputStream(sdfPrivateKey.getIndex(), sdfPrivateKey.getStringPassword());
    }


    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.sigAlgId;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        } catch (Exception e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

}
