package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;

import java.io.*;

/**
 * @ClassName GMSSLIniFileUtils
 * @Description TODO
 * @Date 2020/5/25 11:12
 * @Author FengZhen
 */
public class GMSSLIniFileUtils {

    public static boolean createProfile(String filePath, String ip, int port, String loginPassword, String clientKeyStorePath, String trustKeyStorePath, String clientKeyStorePass, String trustKeyStorePass) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineFeed = "\n";
        sb.append("#SWXA密码设备接口配置文件").append(lineFeed);
        //确定设备  不予修改
        sb.append("[Device]").append(lineFeed);
        sb.append("device=CMD").append(lineFeed);
        //日志等级  GMSSL控制 不对外暴露
        sb.append("[ErrorLog]").append(lineFeed);
        sb.append("level=3").append(lineFeed);
        sb.append("logfile=swsds.log").append(lineFeed);
        sb.append("maxsize=100").append(lineFeed);
        sb.append("count=3").append(lineFeed);
        //密码机服务配置
        sb.append("[HSM1]").append(lineFeed);
        sb.append("ip=").append(ip).append(lineFeed);
        sb.append("port=").append(port).append(lineFeed);
        sb.append("passwd=").append(loginPassword).append(lineFeed);
        // 超时时间配置
        sb.append("[Timeout]").append(lineFeed);
        sb.append("connect=20").append(lineFeed);
        sb.append("service=20").append(lineFeed);
        // 连接池大小
        sb.append("[ConnectionPool]").append(lineFeed);
        sb.append("poolsize=50").append(lineFeed);
        //SSL配置
//        sb.append("[SSL]").append(lineFeed);
//        sb.append("ssl=1").append(lineFeed);
//        sb.append("ssllog=0").append(lineFeed);
//        sb.append("protocol=TLSv1.2").append(lineFeed);
//        sb.append("keystore=").append(clientKeyStorePath).append(lineFeed);
//        sb.append("keystoretype=JKS").append(lineFeed);
//        sb.append("trustkeystore=").append(trustKeyStorePath).append(lineFeed);
//        sb.append("trustkeystoretype=JKS").append(lineFeed);
//        sb.append("includeciphersuitefilter=*_RSA_*_SHA256$").append(lineFeed);
//        sb.append("excludeciphersuitefilter=*_256_*").append(lineFeed);
//        sb.append("trustkeystorepassword=").append(trustKeyStorePass).append(lineFeed);
//        sb.append("keystorepassword=").append(clientKeyStorePass).append(lineFeed);
        GMSSLFileUtils.writeFile(filePath, "swsds.ini", sb.toString().getBytes());
        return true;
    }

    public static boolean setProfileValue(String writePath, String section, String key, String value) throws IOException {
        StringBuilder fileContent;
        String allLine;
        String strLine;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(writePath + File.separator + "swsds.ini"));
        fileContent = new StringBuilder();
        boolean isChange = false;
        try {
            while ((allLine = bufferedReader.readLine()) != null) {
                fileContent.append(allLine + "\n");
                allLine = allLine.trim();
                if (!allLine.startsWith("[")) {
                    continue;
                }
                if (allLine.equalsIgnoreCase("[" + section + "]")) {
                    while ((strLine = bufferedReader.readLine()) != null) {
                        if (strLine.startsWith("[")) {
                            fileContent.append(strLine + "\n");
                            break;
                        }
                        if (strLine.trim().startsWith(key)) {
                            String changeText = strLine.substring(0, strLine.indexOf('=') + 1);
                            changeText = changeText + value;
                            fileContent.append(changeText + "\n");
                            isChange = true;
                        }
                    }
                }
            }
        } catch (IOException e) {
            throw new IOException(e);
        } finally {
            bufferedReader.close();
        }
        System.out.println(fileContent);
        if (isChange) {
            GMSSLX509Utils.writeFile(writePath + File.separator, "swsds.ini", fileContent.toString().getBytes());
            return true;
        }
        return false;
    }

    public static String getProfileValue(String filePath, String item, String key) {
        String str = null;
        item = "[" + item + "]";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            boolean findItem = false;
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.trim().equals("") && line.charAt(0) != '#') {
                    String tmpLine = line.toLowerCase();
                    if (tmpLine.contains(item.toLowerCase())) {
                        findItem = true;
                    } else {
                        if (findItem && tmpLine.contains(key.toLowerCase())) {
                            str = line.substring(line.indexOf("=") + 1);
                            str = str.trim();
                            break;
                        }
                        if (findItem && tmpLine.contains("[")) {
                            break;
                        }
                    }
                }
            }
            br.close();
            return str;
        } catch (Exception e) {
            return null;
        }
    }
}
