/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM4Engine;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSM4BlockCipherUtils {
    public static String encryptByBC(String base64Key, String base64Data) {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.encryptByBC(GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByBC(byte[] key, byte[] data) {
        SM4Engine sM4Engine = new SM4Engine();
        byte[] out = new byte[data.length];
        KeyParameter param = new KeyParameter(key);
        sM4Engine.init(true, (CipherParameters)param);
        sM4Engine.processBlock(data, 0, out, 0);
        return out;
    }

    public static String decryptByBC(String base64Key, String base64Cipher) {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.decryptByBC(GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByBC(byte[] key, byte[] cipher) {
        SM4Engine sM4Engine = new SM4Engine();
        byte[] out = new byte[cipher.length];
        KeyParameter param = new KeyParameter(key);
        sM4Engine.init(false, (CipherParameters)param);
        sM4Engine.processBlock(cipher, 0, out, 0);
        return out;
    }

    public static String encryptByYunhsm(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.sm4EngineBySdf(true, SdfCryptoType.YUNHSM, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static String decryptByYunhsm(String base64Key, String base64Cipher) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.sm4EngineBySdf(false, SdfCryptoType.YUNHSM, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static String encryptByPcie(String base64Key, String base64Data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.sm4EngineBySdf(true, SdfCryptoType.PCIE, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static String decryptByPcie(String base64Key, String base64Cipher) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4BlockCipherUtils.sm4EngineBySdf(false, SdfCryptoType.PCIE, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] sm4EngineByYunHsm(boolean forEncryption, byte[] key, byte[] data) throws Exception {
        return GMSSLSM4BlockCipherUtils.sm4EngineBySdf(forEncryption, SdfCryptoType.YUNHSM, key, data);
    }

    public static byte[] sm4EngineByPCIE(boolean forEncryption, byte[] key, byte[] data) throws Exception {
        return GMSSLSM4BlockCipherUtils.sm4EngineBySdf(forEncryption, SdfCryptoType.PCIE, key, data);
    }

    public static byte[] sm4EngineBySdf(boolean forEncryption, SdfCryptoType sdfCryptoType, byte[] key, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            if (forEncryption) {
                return GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            }
            return GMSSLSM4ECBEncryptUtils.decrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        }
        SdfSM4Engine sdfSM4Engine = new SdfSM4Engine(sdfCryptoType);
        byte[] out = new byte[data.length];
        KeyParameter param = new KeyParameter(key);
        sdfSM4Engine.init(forEncryption, (CipherParameters)param);
        sdfSM4Engine.processBlock(data, 0, out, 0);
        sdfSM4Engine.release();
        return out;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

