/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorStreamException;
import org.bouncycastle.operator.RuntimeOperatorException;

public class GMSSLJcaContentSignerBuilder {
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public GMSSLJcaContentSignerBuilder(String var1) {
        this.signatureAlgorithm = var1;
        this.sigAlgId = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(var1, true);
        this.sigAlgSpec = null;
    }

    public GMSSLJcaContentSignerBuilder(String var1, AlgorithmParameterSpec var2) {
        this.signatureAlgorithm = var1;
        if (!(var2 instanceof PSSParameterSpec)) {
            throw new IllegalArgumentException("unknown sigParamSpec: " + (var2 == null ? "null" : var2.getClass().getName()));
        }
        PSSParameterSpec var3 = (PSSParameterSpec)var2;
        this.sigAlgSpec = var3;
        this.sigAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)GMSSLJcaContentSignerBuilder.createPSSParams(var3));
    }

    public GMSSLJcaContentSignerBuilder setSecureRandom(SecureRandom var1) {
        this.random = var1;
        return this;
    }

    public ContentSigner build(PrivateKey var1) throws OperatorCreationException {
        try {
            final Signature signature = Signature.getInstance(this.signatureAlgorithm);
            final AlgorithmIdentifier var3 = this.sigAlgId;
            if (this.random != null) {
                signature.initSign(var1, this.random);
            } else {
                signature.initSign(var1);
            }
            return new ContentSigner(){
                private SignatureOutputStream stream;
                {
                    this.stream = new SignatureOutputStream(signature);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return var3;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return this.stream.getSignature();
                    }
                    catch (SignatureException var2x) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + var2x.getMessage(), (Throwable)var2x);
                    }
                }
            };
        }
        catch (GeneralSecurityException var4) {
            throw new OperatorCreationException("cannot create signer: " + var4.getMessage(), (Throwable)var4);
        }
    }

    private static RSASSAPSSparams createPSSParams(PSSParameterSpec var0) {
        DefaultDigestAlgorithmIdentifierFinder var1 = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier var2 = var1.find(var0.getDigestAlgorithm());
        AlgorithmIdentifier var3 = var1.find(((MGF1ParameterSpec)var0.getMGFParameters()).getDigestAlgorithm());
        return new RSASSAPSSparams(var2, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)var3), new ASN1Integer((long)var0.getSaltLength()), new ASN1Integer((long)var0.getTrailerField()));
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        SignatureOutputStream(Signature var2) {
            this.sig = var2;
        }

        @Override
        public void write(byte[] var1, int var2, int var3) throws IOException {
            try {
                this.sig.update(var1, var2, var3);
            }
            catch (SignatureException var5) {
                throw new OperatorStreamException("exception in content signer: " + var5.getMessage(), (Throwable)var5);
            }
        }

        @Override
        public void write(byte[] var1) throws IOException {
            try {
                this.sig.update(var1);
            }
            catch (SignatureException var3) {
                throw new OperatorStreamException("exception in content signer: " + var3.getMessage(), (Throwable)var3);
            }
        }

        @Override
        public void write(int var1) throws IOException {
            try {
                this.sig.update((byte)var1);
            }
            catch (SignatureException var3) {
                throw new OperatorStreamException("exception in content signer: " + var3.getMessage(), (Throwable)var3);
            }
        }

        byte[] getSignature() throws SignatureException {
            return this.sig.sign();
        }
    }
}

