package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;

/**
 * @author sxy
 * @description
 * @date 2021年04月02日 16:02
 **/
public class GMSSLSdfFileUtils {
    /**
     * 创建文件
     *
     * @param fileName 文件名
     * @param fileSize 文件大小
     * @return 读取文件的内容
     */
    public static void createFile(String fileName, int fileSize) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.createFile(fileName, fileSize);
        sdfSDK.release();
    }

    /**
     * 写文件
     *
     * @param fileName 文件名
     * @param offset   起始位置
     * @param context  要写入的文件内容
     */
    public static void writeFile(String fileName, int offset, byte[] context) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.writeFile(fileName, offset, context);
        sdfSDK.release();
    }

    /**
     * 创建并且写文件
     *
     * @param fileName 文件名
     * @param context  要写入的文件内容
     */
    public static void createAndWriteFile(String fileName, byte[] context) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getCryptoType();
        if (!cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + cryptoType);
        }
        int length = context.length;
        createFile(fileName, length);
        writeFile(fileName, 0, context);
    }

    /**
     * 读文件
     *
     * @param fileName 文件名
     * @param offset   起始位置
     * @param length   读取文件的长度
     * @return 读取文件的内容
     */
    public static byte[] readFile(String fileName, int offset, int length) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        byte[] out = sdfSDK.readFile(fileName, offset, length);
        sdfSDK.release();
        return out;
    }


    /**
     * 删除文件
     *
     * @param fileName 文件名
     */
    public static void deleteFile(String fileName) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.deleteFile(fileName);
        sdfSDK.release();
    }

}
