package com.xdja.pki.gmssl.tomcat.utils;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.xml.sax.InputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;


class ServerXmlResolver {

    private NodeList childNodes;
    private Element serviceItem;
    private Document doc;
    private File file;

    private void resolveServerXml(String tomcatPath) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        //String path = "F:\\ldap\\CertBuilder\\src\\main\\resources\\server.xml";
        this.file = new File(tomcatPath + File.separator + "conf" + File.separator + "server.xml");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.parse(this.file);
        //获取根root模块
        Element root = this.doc.getDocumentElement();
        NodeList service = root.getElementsByTagName("Service");

        //获取Service模块
        this.serviceItem = (Element) service.item(0);
        //获取Service子Nodes
        this.childNodes = this.serviceItem.getChildNodes();

    }

    private void writeToXml() throws Exception {
        //将修改后的文件重新写入
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Source source = new DOMSource(this.doc);
        Result result = new StreamResult(this.file);
        transformer.transform(source, result);//将 XML==>Source 转换为 Result
    }

    public  void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port) throws Exception {
        addTomcatHttpsPort(tomcatPath, sslProtocol, port, false, false);
    }

    public void addTomcatHttpsPortWithClientAuth(String tomcatPath, String sslProtocol, int port) throws Exception {
        addTomcatHttpsPort(tomcatPath, sslProtocol, port, false, true);
    }

    public void addTomcatHttpsPortWithClientAuthByJKS(String tomcatPath, String sslProtocol, int port) throws Exception {
        addTomcatHttpsPort(tomcatPath, sslProtocol, port, true, true);
    }

    public void addTomcatHttpsPortWithJks(String tomcatPath, int port) throws Exception {
        addTomcatHttpsPort(tomcatPath, null, port, true, false);
    }

    //    public void addTomcatHttpsPortWithBks(String tomcatPath, int port) throws Exception {
//        addTomcatHttpsPort(tomcatPath, null, port, false);
//    }
    public void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port, boolean isJks, boolean isClientAuth) throws Exception {
        addTomcatHttpsPort(tomcatPath, sslProtocol, port, isJks, isClientAuth, "password", "password", "server.keystore", "trust.keystore");
    }

    public void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port, boolean isJks, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) throws Exception {
        resolveServerXml(tomcatPath);
        //遍历Service模块
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (element.getAttribute("port").equalsIgnoreCase(String.valueOf(port))) {
                    Element node = buildNode(isJks, port, sslProtocol, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
                    this.serviceItem.replaceChild(node, element);
                    //有与传入端口相同的端口开启，在配置文件中直接修改并设定标志为ture，该标志表示以及存在相同端口，避免再次添加
                    flag = true;
                }
            }
        }
        //没有与传入端口相同的端口开启，则在配置文件中直接添加
        if (!flag) {
            Element node = buildNode(isJks, port, sslProtocol, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
            this.serviceItem.appendChild(node);
        }
        writeToXml();
        String xmlPath = tomcatPath + File.separator + "conf";
        GMSSLX509Utils.writeFile(xmlPath, "server.xml", format(xmlPath + File.separator + "server.xml").getBytes());
    }


    private Element buildNode(boolean isJks, int port, String sslProtocol, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) {
        Element connect = this.doc.createElement("Connector");
        Element node;
        if (isJks) {
            node = createTLSHttpsElement(connect, port, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
        } else {
            node = createSSLHttpsElement(connect, port, sslProtocol, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
        }
        return node;
    }

    public void addTomcatHttpPort(String tomcatPath, int port) throws Exception {
        resolveServerXml(tomcatPath);
        //遍历Service模块
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (element.getAttribute("port").equalsIgnoreCase(String.valueOf(port))) {
                    Element connect = this.doc.createElement("Connector");
                    Element node = createHttpElement(connect, port);
                    this.serviceItem.replaceChild(node, element);
                    //有与传入端口相同的端口开启，在配置文件中直接修改并设定标志为ture，该标志表示以及存在相同端口，避免再次添加
                    flag = true;
                }
            }
        }
        //没有与传入端口相同的端口开启，则在配置文件中直接添加
        if (!flag) {
            Element connect = this.doc.createElement("Connector");
            Element node = createHttpElement(connect, port);
            this.serviceItem.appendChild(node);
        }
        writeToXml();
        String xmlPath = tomcatPath + File.separator + "conf";
        GMSSLX509Utils.writeFile(xmlPath, "server.xml", format(xmlPath + File.separator + "server.xml").getBytes());
    }


    public void closeTomcatPort(String tomcatPath, int port) throws Exception {
        resolveServerXml(tomcatPath);
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (String.valueOf(port).equalsIgnoreCase(element.getAttribute("port"))) {
                    //如果是https
                    if ("https".equalsIgnoreCase(element.getAttribute("scheme"))) {
                        String certPath = tomcatPath + File.separator + "conf" + File.separator + "cert" + File.separator + port;
                        GMSSLFileUtils.deleteDirectory(certPath);
                    }
                    this.serviceItem.removeChild(element);
                }
            }
        }
        writeToXml();
        String xmlPath = tomcatPath + File.separator + "conf";
        GMSSLX509Utils.writeFile(xmlPath, "server.xml", format(xmlPath + File.separator + "server.xml").getBytes());
    }


    private Element createHttpElement(Element connect, int port) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "HTTP/1.1");
        connect.setAttribute("connectionTimeout", "20000");
        connect.setAttribute("redirectPort", "8443");
        return connect;
    }

    private Element createSSLHttpsElement(Element connect, int port, String sslProtocol, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
        connect.setAttribute("maxThreads", "150");
        connect.setAttribute("scheme", "https");
        connect.setAttribute("SSLEnabled", "true");
        connect.setAttribute("sslProtocol", sslProtocol);
        connect.setAttribute("secure", "true");
        connect.setAttribute("sslImplementationName", "com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");
        connect.setAttribute("keystoreFile", "conf/cert/" + port + File.separator + serverKeyStoreName);
        connect.setAttribute("keystorePass", serverKeyStorePassword);
        connect.setAttribute("keystoreProvider", "BC");
        connect.setAttribute("keystoreType", "BKS");
        connect.setAttribute("truststoreFile", "conf/cert/" + port + File.separator + trustKeyStoreName);
        connect.setAttribute("truststorePass", trustKeyStorePassword);
        connect.setAttribute("truststoreProvider", "BC");
        connect.setAttribute("truststoreType", "BKS");
        if (isClientAuth) {
            connect.setAttribute("clientAuth", "true");
        } else {
            connect.setAttribute("clientAuth", "false");
        }
        return connect;
    }

    private Element createTLSHttpsElement(Element connect, int port, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
        connect.setAttribute("maxThreads", "150");
        connect.setAttribute("scheme", "https");
        connect.setAttribute("SSLEnabled", "true");
        connect.setAttribute("sslProtocol", "TLSV1.2");
        connect.setAttribute("secure", "true");
        connect.setAttribute("keystoreFile", "conf/cert/" + port + File.separator + serverKeyStoreName);
        connect.setAttribute("keystorePass", serverKeyStorePassword);
        connect.setAttribute("keystoreType", "JKS");
        connect.setAttribute("truststoreFile", "conf/cert/" + port + File.separator + trustKeyStoreName);
        connect.setAttribute("truststorePass", trustKeyStorePassword);
        connect.setAttribute("truststoreType", "JKS");
        if (isClientAuth) {
            connect.setAttribute("clientAuth", "true");
        } else {
            connect.setAttribute("clientAuth", "false");
        }
        return connect;
    }

//    private Element createTLSBKSHttpsElement(Element connect, int port) {
//        connect.setAttribute("port", String.valueOf(port));
//        connect.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
//        connect.setAttribute("maxThreads", "150");
//        connect.setAttribute("scheme", "https");
//        connect.setAttribute("sslProtocol", "TLSV1.2");
//        connect.setAttribute("SSLEnabled", "true");
//        connect.setAttribute("secure", "true");
//        connect.setAttribute("truststoreProvider", "BC");
//        connect.setAttribute("keystoreFile", "conf/cert/" + port + "/server.keystore");
//        connect.setAttribute("keystorePass", "password");
//        connect.setAttribute("keystoreType", "BKS");
//        connect.setAttribute("sslImplementationName","com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");
//        connect.setAttribute("keystoreProvider", "BC");
//        connect.setAttribute("truststoreFile", "conf/cert/" + port + "/trust.keystore");
//        connect.setAttribute("truststorePass", "password");
//        connect.setAttribute("truststoreType", "BKS");
//        return connect;
//    }


    public static String format(String filePath) {
        try {
            File file = new File(filePath);
            String file2String = GMSSLFileUtils.fileToString(file, "utf-8");
            final Document document = parseXmlFile(file2String);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
            Writer out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer(out, format);
            serializer.serialize(document);
            return out.toString();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    private static Document parseXmlFile(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
