package com.xdja.pki.gmssl.x509.utils.bean;

import java.util.Date;

public class CRLEntry {
    private String userCertificateSerial;
    private Date revocationDate;
    private int reason;

    public CRLEntry() {
    }

    /**
     * CRL实体类
     *
     * @param userCertificateSerial 证书序列号 big integer to string 16
     * @param revocationDate        撤销时间
     * @param reason                撤销原因
     */
    public CRLEntry(String userCertificateSerial, Date revocationDate, int reason) {
        this.userCertificateSerial = userCertificateSerial;
        this.revocationDate = revocationDate;
        this.reason = reason;
    }

    public String getUserCertificateSerial() {
        return userCertificateSerial;
    }

    public void setUserCertificateSerial(String userCertificateSerial) {
        this.userCertificateSerial = userCertificateSerial;
    }

    public Date getRevocationDate() {
        return revocationDate;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public int getReason() {
        return reason;
    }

    public void setReason(int reason) {
        this.reason = reason;
    }
}