package com.xdja.pki.gmssl.crypto.init;


import com.xdja.SafeKey.utils.pool.MiniPcieConnectionPool;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;

import java.io.File;
import java.security.Security;

/**
 * @ClassName GMSSLPkiCryptoInit
 * @Description TODO
 * @Date 2020/5/18 16:24
 * @Author FengZhen
 */
public class GMSSLPkiCryptoInit {

    private static GMSSLCryptoType cryptoType = GMSSLCryptoType.BC;
    private static int maxTotal = 100;


    private GMSSLPkiCryptoInit(GMSSLCryptoType cryptoType) {
        GMSSLPkiCryptoInit.cryptoType = cryptoType;
    }

    public static GMSSLCryptoType getCryptoType() {
        return cryptoType;
    }

    public static GMSSLCryptoType getSdfCryptoType() throws Exception {
        if (!cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + cryptoType);
        }
        return cryptoType;
    }

    /**
     * BC软实现
     */
    public static void getBCInstance() {
        new GMSSLPkiCryptoInit(GMSSLCryptoType.BC);
    }


    /**
     * 信大捷安密码机实现
     */
    public static void getXdjaYunHsmInstance() {
        HsmConnectionProviderImpl.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.XDJA_HSM);
    }

    /**
     * PCIE实现
     */
    public static void getPcieInstance() {
        PcieConnectionProviderImpl.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.PCI_E);
    }

    /**
     * MiniPCIE实现
     */
    public static void getMiniPcieInstance() {
        MiniPcieConnectionPool.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.MINI_PCI_E);
    }

    /**
     * 三未信安密码机实现
     */
    public static void getSancHsmInstance() throws Exception {
        GMSSLSancConnectionUtils.init();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }

    /**
     * 三未信安密码机实现 本地路径调试使用  正常上服务不建议使用
     *
     * @param configPath 配置文件路径
     */
    public static void getSancHsmInstance(String configPath) throws Exception {
        GMSSLSancConnectionUtils.init(configPath);
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }
}
