package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import org.bouncycastle.asn1.ASN1Encoding;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

/**
 * @description: 签名hash预处理工具类
 * @author: feng zhen
 * @date: 2020/6/2 11:08
 **/
public class GMSSLSancDigestPreProcessUtils {
    /**
     * SM2签名使用SM3预处理
     *
     * @param publicKey 签名公钥
     * @param data      签名数据
     * @param userId    签名userId
     * @return
     * @throws Exception
     */

    public static byte[] sm3Digest(PublicKey publicKey, byte[] data, byte[] userId) {
        if (null == userId) {
            return GMSSLSM3DigestUtils.digestByBCWithPublicKey((ECPublicKey) publicKey, data);
        }
        return GMSSLSM3DigestUtils.digestByBCWithPublicKey((ECPublicKey) publicKey, data, userId);
    }

    public static byte[] sha1Digest(byte[] data) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, DERNull.INSTANCE);
        byte[] digest = GMSSLSHA1DigestUtils.digestByBC(data);
        return derEncode(algorithmIdentifier, digest);
    }

    public static byte[] sha256Digest(byte[] data) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        byte[] digest = GMSSLSHA256DigestUtils.digestByBC(data);
        return derEncode(algorithmIdentifier, digest);
    }

    private static byte[] derEncode(AlgorithmIdentifier algId, byte[] hash) throws IOException {
        DigestInfo dInfo = new DigestInfo(algId, hash);
        return dInfo.getEncoded(ASN1Encoding.DER);
    }
}
