package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifier;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

import java.security.PublicKey;

/**
 * @ClassName GMSSLXkfContentVerifierProvider
 * @Description TODO
 * @Date 2020/5/21 19:26
 * @Author FengZhen
 */
public class GMSSLXkfContentVerifierProvider implements ContentVerifierProvider {
    private PublicKey publicKey;

    public GMSSLXkfContentVerifierProvider(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public boolean hasAssociatedCertificate() {
        return false;
    }

    @Override
    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    @Override
    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        try {
            return new GMSSLXkfContentVerifier(verifierAlgorithmIdentifier, publicKey);
        } catch (Exception e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }
}
