package com.xdja.pki.gmssl.tomcat.utils;


import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GMSSLTomcatUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLTomcatUtils.class);

    public final static String GMSSLV11 = "GMSSLV1.1";
    public final static String GMSSLSDFYUNHSMV11 = "GMSSLSDFYUNHSMV1.1";
    public final static String GMSSLSDFPCIEV11 = "GMSSLSDFPCIEV1.1";
    public final static String GMSSLXDJASDFYUNHSMV11 = "GMSSLXDJASDFYUNHSMV1.1";
    public final static String GMSSLXDJASDFPCIEV11 = "GMSSLXDJASDFPCIEV1.1";

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCert        信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param tomcatPath       tomcat绝对路径
     * @param port             需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    @Deprecated
    public static void openHttpsPortByBC(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                         PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port);

    }


    /**
     * 服务器使用RSA证书开启https通道
     *
     * @param trustCert        信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param tomcatPath       tomcat绝对路径
     * @param port             需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    @Deprecated
    public static void openHttpsPortByJKSWithRSA(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                 PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), true);
        serverXmlResolver.addTomcatHttpsPortWithJks(tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts       信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param port             需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByJKSWithRSA(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                 PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        openHttpsPortByJKSWithRSA(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts   信任证书
     * @param serveCert    服务器签名证书
     * @param serverPriKey 服务器加密证书
     * @param port         需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByJKSWithNIST(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        openHttpsPortByJKSWithNIST(trustCerts, serveCert, serverPriKey, port, tomcatPath);
    }

    public static void openHttpsPortByJKSWithNIST(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port, String tomcatPath) throws Exception {
        openHttpsPortByJKSWithRSA(trustCerts, serveCert, null, serverPriKey, null, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts   信任证书
     * @param serveCert    服务器证书
     * @param serverPriKey 服务器证书私钥
     * @param port         需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByYJKSWithClientAuth(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        saveKeyStore(trustCerts, serveCert, null, serverPriKey, null, tomcatPath, String.valueOf(port), true);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPortWithClientAuthByJKS(tomcatPath, GMSSLV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts       信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param port             需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByJKSWithNist(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                  PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        openHttpsPortByJKSWithRSA(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts       信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param port             需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByJKSWithNist(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                  PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        openHttpsPortByJKSWithRSA(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts       信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param tomcatPath       tomcat绝对路径
     * @param port             需要开启的TLSV1.2通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByJKSWithRSA(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                 PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), true);
        serverXmlResolver.addTomcatHttpsPortWithJks(tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCert        信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param port             需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByBC(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                         PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCert        信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param tomcatPath       tomcat绝对路径
     * @param port             需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByBC(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                         PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port);

    }


    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCert        信任证书
     * @param serveSignCert    服务器签名证书
     * @param serverEncCert    服务器加密证书
     * @param serverSignPriKey 服务器签名私钥
     * @param serverEncPriKey  服务器加密私钥
     * @param tomcatPath       tomcat绝对路径
     * @param port             需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByBCWithClientAuth(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                       PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPortWithClientAuth(tomcatPath, GMSSLV11, port);

    }


    /**
     * 服务器初始化tomcat调用接口
     * 使用服务器密码机 进行sm2密钥计算
     *
     * @param trustCert                  信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByYunHsm(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                             int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                             String tomcatPath, int port) throws Exception {

        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCert, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLSDFYUNHSMV11, port);
    }


    /**
     * 服务器初始化tomcat调用接口
     * 使用服务器密码机 进行sm2密钥计算
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                             int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        openHttpsPortByYunHsm(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     * 使用服务器密码机 进行sm2密钥计算
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                             int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                             String tomcatPath, int port) throws Exception {

        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLSDFYUNHSMV11, port);
    }


    /**
     * 服务器初始化tomcat调用接口
     * 使用服务器密码机 进行sm2密钥计算
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByYunHsmWithClientAuth(List<X509Certificate> trustCerts,
                                                           X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                           int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                                           String tomcatPath, int port) throws Exception {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPortWithClientAuth(tomcatPath, GMSSLSDFYUNHSMV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     * 使用PCIE卡 进行sm2密钥计算
     *
     * @param trustCert                  信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByPCIE(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                           int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                           String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCert, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLSDFPCIEV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     * 使用PCIE卡 进行sm2密钥计算
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByPCIE(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                           int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                           String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLSDFPCIEV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     * 使用PCIE卡 进行sm2密钥计算
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByPCIEWithClientAuth(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                         int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                                         String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPortWithClientAuth(tomcatPath, GMSSLSDFPCIEV11, port);
    }


    /**
     * 服务器初始化tomcat调用接口
     * 使用服务器密码机 进行密钥计算
     *
     * @param trustCert                  信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByXDJAYunHsm(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                 int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                                 String tomcatPath, int port) throws Exception {

        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCert, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLXDJASDFYUNHSMV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByXDJAYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                                 int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                                 String tomcatPath, int port) throws Exception {

        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLXDJASDFYUNHSMV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCert                  信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByXDJAPCIE(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                               int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                               String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCert, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLXDJASDFPCIEV11, port);
    }

    /**
     * 服务器初始化tomcat调用接口
     *
     * @param trustCerts                 信任证书
     * @param serveSignCert              服务器签名证书
     * @param serverEncCert              服务器加密证书
     * @param caServerPrivateKeyIndex    服务器证书密钥控制索引
     * @param caServerPrivateKeyPassword 服务器证书密钥控制访问码
     * @param tomcatPath                 tomcat绝对路径
     * @param port                       需要开启的GMSSL通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpsPortByXDJAPCIE(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert,
                                               int caServerPrivateKeyIndex, String caServerPrivateKeyPassword,
                                               String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        saveKeyStore(trustCerts, serveSignCert, serverEncCert, sdfPrivateKey, sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLXDJASDFPCIEV11, port);
    }


    /**
     * 通过BKS  KeyStore构建https通道
     *
     * @param serverKeyStore         服务器证书KeyStore
     * @param trustKeyStore          信任证书KeyStore
     * @param port                   开启的端口
     * @param isClientAuth           双向认证
     * @param serverKeyStorePassword 服务器KeyStore密码
     * @param trustKeyStorePassword  信任证书KeyStore密码
     * @throws Exception
     */
    public static void openHttpsPortByKeyStoreWithBKS(KeyStore serverKeyStore, KeyStore trustKeyStore, int port, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword) throws Exception {
        //    private void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port, boolean isJks, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        String serverKeyStoreName = "signAndEncCert_" + serverKeyStorePassword;
        String trustKeyStoreName = "ca_" + trustKeyStorePassword;
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(tomcatPath, serverKeyStore, trustKeyStore, port, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName, true);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port, false, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
    }

    /**
     * 通过JKS  KeyStore构建https通道
     *
     * @param serverKeyStore         服务器证书KeyStore
     * @param trustKeyStore          信任证书KeyStore
     * @param port                   开启的端口
     * @param isClientAuth           双向认证
     * @param serverKeyStorePassword 服务器KeyStore密码
     * @param trustKeyStorePassword  信任证书KeyStore密码
     * @throws Exception
     */
    public static void openHttpsPortByKeyStoreWithJKS(KeyStore serverKeyStore, KeyStore trustKeyStore, int port, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword) throws Exception {
        //    private void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port, boolean isJks, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        String serverKeyStoreName = "signAndEncCert_" + serverKeyStorePassword;
        String trustKeyStoreName = "ca_" + trustKeyStorePassword;
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        saveKeyStore(tomcatPath, serverKeyStore, trustKeyStore, port, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName, false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port, false, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
    }

    private static void saveKeyStore(String tomcatPath, KeyStore serverKeyStore, KeyStore trustKeyStore, int port, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName, boolean isBks) throws Exception {
        String path = tomcatPath + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator;
        File pathf = new File(path);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        if (isBks) {
            GMSSLKeyStoreUtils.saveGMSSLBKSKeyStore(serverKeyStore, serverKeyStorePassword, path, serverKeyStoreName);
            GMSSLKeyStoreUtils.saveGMSSLBKSKeyStore(trustKeyStore, trustKeyStorePassword, path, trustKeyStoreName);
        } else {
            GMSSLKeyStoreUtils.saveGMSSLJKSKeyStore(serverKeyStore, serverKeyStorePassword, path, serverKeyStoreName);
            GMSSLKeyStoreUtils.saveGMSSLJKSKeyStore(trustKeyStore, trustKeyStorePassword, path, trustKeyStoreName);
        }
    }

    /**
     * 开tomcat  http 服务端口
     *
     * @param tomcatPath tomcat绝对路径
     * @param port       需要Http服务通道端口号k
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void openHttpPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpPort(tomcatPath, port);
    }

    /**
     * 关闭tomcat服务端口 http和https端口公用一个方法
     *
     * @param tomcatPath tomcat绝对路径
     * @param port       需要关闭的通道端口号
     * @throws Exception 生成KeyStore产生的各种异常以及读写证书和操作XML文件时产生的各种异常
     */
    public static void closeTomcatPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.closeTomcatPort(tomcatPath, port);
    }

    @Deprecated
    public static boolean restartTomcat(String tomcatPath) {
        if (!shutdownTomcat(tomcatPath)) {
            return false;
        }
        return startupTomcat(tomcatPath);
    }

    @Deprecated
    public static boolean restartTomcat(String tomcatPath, String shutdownShellPath) {
        if (!run(tomcatPath, "shutdown.sh " + tomcatPath, true, shutdownShellPath)) {
            return false;
        }
        return startupTomcat(tomcatPath);
    }


    public static boolean shutdownTomcat(String tomcatPath) {
        return run(tomcatPath, "shutdown", false);
    }

    public static boolean startupTomcat(String tomcatPath) {
        return run(tomcatPath, "startup", false);
    }


    private static void saveKeyStore(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port, boolean isJks) throws Exception {
        List<X509Certificate> certs = new ArrayList<>();
        certs.add(trustCert);
        saveKeyStore(certs, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, path, port, isJks);
    }

    public static void saveKeyStore(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port, boolean isJKS) throws Exception {

        path = path + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator;
        File pathf = new File(path);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";
        KeyStore serverKeyStore;
        if (isJKS) {
            if (null == serverEncCert) {
                serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithJKS(password, trustCerts,
                        signAlias, serverSignPriKey, serveSignCert);
            } else {
                serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, trustCerts,
                        signAlias, serverSignPriKey, serveSignCert,
                        encAlias, serverEncPriKey, serverEncCert, "JKS");
            }
        } else {
            serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, trustCerts,
                    signAlias, serverSignPriKey, serveSignCert,
                    encAlias, serverEncPriKey, serverEncCert, "BKS");
        }
        for (int i = 0; i < trustCerts.size(); i++) {
            GMSSLX509Utils.writeCertificateToPem(path, "ca_" + i, trustCerts.get(i));
            GMSSLX509Utils.writeObjectToPem(path, "ca_public_" + i, trustCerts.get(i).getPublicKey());
            GMSSLX509Utils.writeCertificateToCer(path, "ca_" + i, trustCerts.get(i));
        }
        GMSSLX509Utils.writeCertificateToPem(path, "sign", serveSignCert);
        GMSSLX509Utils.writeObjectToPem(path, "sign_public", serveSignCert.getPublicKey());
        KeyStore trustKeyStore;
        if (isJKS) {
            trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithJKS(trustCerts);
        } else {
            trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(trustCerts);
        }
        if (serverSignPriKey instanceof SdfPrivateKey) {
            GMSSLX509Utils.writeSdfPrivateKey(path, "ca_server_key", serverSignPriKey);
        } else {
            GMSSLX509Utils.writeObjectToPem(path, "sign_private", serverSignPriKey);
            if (null != serverEncCert) {
                GMSSLX509Utils.writeKeyStoreToP12(serverKeyStore, "password".toCharArray(), path, "enc");
                GMSSLX509Utils.writeObjectToPem(path, "enc_private", serverEncPriKey);
            }
            GMSSLKeyStoreUtils.printGMSSLKeyStore(trustKeyStore, password);
            GMSSLX509Utils.writeKeyStoreToP12(serverKeyStore, "password".toCharArray(), path, "sign");
            GMSSLX509Utils.writeKeyStoreToP12(trustKeyStore, "password".toCharArray(), path + "/trust");
        }
        if (null != serverEncCert) {
            GMSSLX509Utils.writeCertificateToPem(path, "enc", serverEncCert);
            GMSSLX509Utils.writeCertificateToCer(path, "enc", serverEncCert);
        }
        GMSSLX509Utils.writeCertificateToCer(path, "sign", serveSignCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(serverKeyStore, "password", path, "server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(trustKeyStore, "password", path, "trust");
    }


    /**
     * 启动Tomcat程序
     *
     * @param tomcatPath
     * @param shName
     */
    private static boolean run(String tomcatPath, String shName, boolean isUseShutdownSh, String... shPath) {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            String os = System.getProperty("os.name");
            if (shName.contains("shut")) {
                logger.info("=================开始关闭Tomcat=================");
            } else {
                logger.info("=================开始启动Tomcat=================");
            }
            if (os.startsWith("Windows")) {
                ps = rt.exec("cmd /c " + tomcatPath + File.separator + "bin" + File.separator + shName + ".bat", null, new File(tomcatPath));
            } else {
                if (isUseShutdownSh) {
                    ps = rt.exec("sh " + shPath[0] + File.separator + shName, null, new File(shPath[0]));
                } else {
                    ps = rt.exec("sh " + tomcatPath + File.separator + "bin" + File.separator + shName + ".sh", null, new File(tomcatPath));
                }

            }
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            is.close();
            reader.close();
            ps.destroy();
            logger.info("=================完成=================");
            return true;
        } catch (Exception e) {
            logger.error(shName + " tomcat is error ", e);
            return false;
        }
    }

    public static boolean restartTomcat() {
        String tomcatPath = System.getProperty("catalina.home");
        if (!shutdownTomcat(tomcatPath)) {
            return false;
        }
        return startupTomcat(tomcatPath);
    }

    public static boolean restartTomcatWithSh() {
        InputStream resourceAsStream = GMSSLTomcatUtils.class.getClassLoader().getResourceAsStream("restart.sh");
        return restart(resourceAsStream);
    }

    private static boolean restart(InputStream inputStream) {
        String home = System.getProperty("catalina.home");
        logger.debug("Restart Tomcat Begin {}", home);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(new Runnable() {
            @Override
            public void run() {
                try {
                    String restartCMDPath = "$CATALINA_HOME/bin/restart.sh";
                    restartCMDPath = restartCMDPath.replace("$CATALINA_HOME", home);
                    File restartFile = new File(restartCMDPath);
                    if (!restartFile.exists()) {
                        logger.debug("restart.sh 文件不存在，复制文件...");
                        Files.copy(inputStream, restartFile.toPath());
                        logger.debug("restart.sh 复制文件成功...");
                    }
                    boolean chmod = restartFile.setExecutable(true, true);
                    logger.debug("restart.sh 添加可执行权限 {}", chmod);
                    runCmd("chmod 755 " + restartCMDPath);

                    long millis = 9000;
                    logger.debug("Restart Tomcat Sleep {}ms", millis);
                    Thread.sleep(millis);
                    logger.debug("Restart Tomcat Weak Up {}ms", millis);

                    runCmd(restartCMDPath);
                } catch (Exception e) {
                    logger.error("重启tomcat失败", e);
                    throw new RuntimeException("重启tomcat失败", e);
                }
            }
        });
        return true;
    }

    private static void runCmd(String cmd) throws IOException, InterruptedException {
        logger.debug("Start Run Cmd {}", cmd);
        Process process = Runtime.getRuntime().exec(cmd);

        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));

        String line;
        while ((line = reader.readLine()) != null) {
            output.append(line + "\n");
        }
        reader.close();

        int exitVal = process.waitFor();
        if (exitVal == 0) {
            logger.debug("Run Cmd Success!", cmd);
            logger.debug("Run Cmd output is {}", output.toString());
        } else {
            logger.error("Run Cmd Fail! exitVal = {}", exitVal);
        }
    }
}