/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.init;

import com.xdja.SafeKey.utils.pool.MiniPcieConnectionPool;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLPkiCryptoInit {
    private static GMSSLCryptoType cryptoType = GMSSLCryptoType.BC;
    private static int maxTotal = 100;
    private static String JSON_PATH = File.separator + "etc" + File.separator + "xdsdfjni.json";
    private static Logger logger = LoggerFactory.getLogger(GMSSLPkiCryptoInit.class);

    private GMSSLPkiCryptoInit(GMSSLCryptoType cryptoType) {
        GMSSLPkiCryptoInit.cryptoType = cryptoType;
    }

    public static GMSSLCryptoType getCryptoType() {
        return cryptoType;
    }

    public static GMSSLCryptoType getSdfCryptoType() throws Exception {
        if (!cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + (Object)((Object)cryptoType));
        }
        return cryptoType;
    }

    public static void getBCInstance() {
        new GMSSLPkiCryptoInit(GMSSLCryptoType.BC);
    }

    public static void getHsmInstance() {
        GMSSLPkiCryptoInit.getHsmInstance(GMSSLHsmUtils.getConfPath(false));
    }

    public static void getHsmInstance(String confPath) {
        String jsonPath = confPath + JSON_PATH;
        logger.info("\u8bfb\u53d6json\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + jsonPath);
        HsmUtils.resetHsmconfigPath((String)jsonPath);
        HsmUtils.setHsmType();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.XDJA_HSM);
    }

    public static void getXdjaYunHsmInstance() {
        new GMSSLPkiCryptoInit(GMSSLCryptoType.XDJA_HSM);
    }

    public static void getPcieInstance() {
        PcieConnectionProviderImpl.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.PCI_E);
    }

    public static void getMiniPcieInstance() {
        MiniPcieConnectionPool.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.MINI_PCI_E);
    }

    public static void getSancHsmInstance() throws Exception {
        GMSSLSancConnectionUtils.init();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }

    public static void getSancHsmInstance(String configPath) throws Exception {
        GMSSLSancConnectionUtils.init(configPath);
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }
}

