/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.xdja.SafeKey.utils.MiniPcieSymmetricEncryptUtils;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSM4CBCEncryptUtils {
    public static byte[] encryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptWithKekBySdf(true, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] decryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptWithKekBySdf(false, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] encryptCBC(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        return GMSSLSM4CBCEncryptUtils.encrypt(key, data, iv, paddingType, false);
    }

    @Deprecated
    public static byte[] encrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        return GMSSLSM4CBCEncryptUtils.encrypt(key, data, iv, paddingType, true);
    }

    public static byte[] encrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType, boolean isECB) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, paddingType, key, iv, data);
            }
            case XDJA_HSM: {
                return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, paddingType, key, iv, data);
            }
            case MINI_PCI_E: {
                switch (paddingType) {
                    case NoPadding: {
                        return MiniPcieXKFUtils.sm4((byte[])key, (byte[])data, (int)17, (byte[])iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return MiniPcieSymmetricEncryptUtils.sm4CbcWithPkcs5Padding((byte[])key, (byte[])data, (byte[])iv, (boolean)true);
                    }
                }
                return MiniPcieSymmetricEncryptUtils.sm4CbcWithSslv3Padding((byte[])key, (byte[])data, (byte[])iv, (boolean)true);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                switch (paddingType) {
                    case NoPadding: {
                        return cryptConnection.encrypt(8194, key, iv, data);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        data = GMSSLX509Utils.paddingData((byte[])data, (boolean)true);
                        return cryptConnection.encrypt(8194, key, iv, data);
                    }
                }
                data = GMSSLX509Utils.paddingData((byte[])data, (boolean)false);
                return cryptConnection.encrypt(8194, key, iv, data);
            }
            case BC: {
                if (isECB) {
                    switch (paddingType) {
                        case NoPadding: {
                            return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding, key, data, iv);
                        }
                        case PKCS7Padding: 
                        case PKCS5Padding: {
                            return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding, key, data, iv);
                        }
                    }
                    throw new IllegalArgumentException("un support the sm4 ecb sslv3Padding encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
                }
                switch (paddingType) {
                    case NoPadding: {
                        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, key, data, iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, key, data, iv);
                    }
                }
                throw new IllegalArgumentException("un support the sm4 ecb sslv3Padding encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
            }
        }
        throw new IllegalArgumentException("un support the sm4 cbc encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] decryptCBC(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        return GMSSLSM4CBCEncryptUtils.decrypt(key, data, iv, paddingType, false);
    }

    @Deprecated
    public static byte[] decrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        return GMSSLSM4CBCEncryptUtils.decrypt(key, data, iv, paddingType, true);
    }

    public static byte[] decrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType, boolean isECB) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, paddingType, key, iv, data);
            }
            case XDJA_HSM: {
                return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, paddingType, key, iv, data);
            }
            case MINI_PCI_E: {
                switch (paddingType) {
                    case NoPadding: {
                        return MiniPcieXKFUtils.sm4((byte[])key, (byte[])data, (int)16, (byte[])iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return MiniPcieSymmetricEncryptUtils.sm4CbcWithPkcs5Padding((byte[])key, (byte[])data, (byte[])iv, (boolean)false);
                    }
                }
                return MiniPcieSymmetricEncryptUtils.sm4CbcWithSslv3Padding((byte[])key, (byte[])data, (byte[])iv, (boolean)false);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                switch (paddingType) {
                    case NoPadding: {
                        return cryptConnection.decrypt(8194, key, iv, data);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        byte[] decrypt = cryptConnection.decrypt(8194, key, iv, data);
                        return GMSSLX509Utils.removePadding((byte[])data, (byte[])decrypt, (boolean)true);
                    }
                }
                byte[] decryptSsl3 = cryptConnection.decrypt(8194, key, iv, data);
                return GMSSLX509Utils.removePadding((byte[])data, (byte[])decryptSsl3, (boolean)false);
            }
            case BC: {
                if (isECB) {
                    switch (paddingType) {
                        case NoPadding: {
                            return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_NoPadding, key, data, iv);
                        }
                        case PKCS7Padding: 
                        case PKCS5Padding: {
                            return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_ECB_PKCS5Padding, key, data, iv);
                        }
                    }
                    throw new IllegalArgumentException("un support the sm4 ecb sslv3Padding decrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
                }
                switch (paddingType) {
                    case NoPadding: {
                        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, key, data, iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, key, data, iv);
                    }
                }
                throw new IllegalArgumentException("un support the sm4 ecb sslv3Padding decrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
            }
        }
        throw new IllegalArgumentException("un support the sm4 cbc decrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static String encryptByBCWithNoPadding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] encryptByBCWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, key, data, initIV);
    }

    public static String encryptByBCWithPKCS5Padding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] encryptByBCWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, key, data, initIV);
    }

    public static String encryptByBCWithPKCS7Padding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] encryptByBCWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(true, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS7Padding, key, data, initIV);
    }

    public static String decryptByBCWithNoPadding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] decryptByBCWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_NoPadding, key, data, initIV);
    }

    public static String decryptByBCWithPKCS5Padding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] decryptByBCWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS5Padding, key, data, initIV);
    }

    public static String decryptByBCWithPKCS7Padding(String base64Key, String base64Data, String base64InitIV) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64Data), GMSSLByteArrayUtils.base64Decode((String)base64InitIV)));
    }

    public static byte[] decryptByBCWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptByBC(false, GMSSLSymmetricEncryptUtils.EncryptTypeByBC.SM4_CBC_PKCS7Padding, key, data, initIV);
    }

    public static String encryptByYumhsmWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByYumhsmWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, key, initIV, data);
    }

    public static String encryptByYumhsmWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByYumhsmWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, key, initIV, data);
    }

    public static String encryptByYumhsmWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByYumhsmWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, initIV, data);
    }

    public static String encryptByYumhsmWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByYumhsmWithSSL3Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, key, initIV, data);
    }

    public static String decryptByYumhsmWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByYumhsmWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, key, initIV, data);
    }

    public static String decryptByYumhsmWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByYumhsmWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, key, initIV, data);
    }

    public static String decryptByYumhsmWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByYumhsmWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, initIV, data);
    }

    public static String decryptByYumhsmWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByYumhsmWithSSL3Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, key, initIV, data);
    }

    public static String encryptByPcieWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByPcieWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, key, initIV, data);
    }

    public static String encryptByPcieWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByPcieWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, key, initIV, data);
    }

    public static String encryptByPcieWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByPcieWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, initIV, data);
    }

    public static String encryptByPcieWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Data)));
    }

    public static byte[] encryptByPcieWithSSL3Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, key, initIV, data);
    }

    public static String decryptByPcieWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByPcieWithNoPadding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, key, initIV, data);
    }

    public static String decryptByPcieWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByPcieWithPKCS5Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, key, initIV, data);
    }

    public static String decryptByPcieWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByPcieWithPKCS7Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, initIV, data);
    }

    public static String decryptByPcieWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode((String)base64Key), GMSSLByteArrayUtils.base64Decode((String)base64InitIv), GMSSLByteArrayUtils.base64Decode((String)base64Cipher)));
    }

    public static byte[] decryptByPcieWithSSL3Padding(byte[] key, byte[] data, byte[] initIV) throws Exception {
        return GMSSLSM4CBCEncryptUtils.sm4SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, key, initIV, data);
    }

    public static byte[] sm4SymmetricWithPaddingByPCIE(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.PCIE, paddingType, key, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);
    }

    public static byte[] sm4SymmetricWithPaddingByYunHsm(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);
    }

    public static byte[] sm4SymmetricSdfWithPadding(boolean forEncryption, SdfCryptoType sdfCryptoType, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, sdfCryptoType, paddingType, key, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

