/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class GMSSLSancDigestPreProcessUtils {
    public static byte[] sm3Digest(PublicKey publicKey, byte[] data, byte[] userId) {
        if (null == userId) {
            return GMSSLSM3DigestUtils.digestByBCWithPublicKey((ECPublicKey)publicKey, data);
        }
        return GMSSLSM3DigestUtils.digestByBCWithPublicKey((ECPublicKey)publicKey, data, userId);
    }

    public static byte[] sha1Digest(byte[] data) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, (ASN1Encodable)DERNull.INSTANCE);
        byte[] digest = GMSSLSHA1DigestUtils.digestByBC(data);
        return GMSSLSancDigestPreProcessUtils.derEncode(algorithmIdentifier, digest);
    }

    public static byte[] sha256Digest(byte[] data) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        byte[] digest = GMSSLSHA256DigestUtils.digestByBC(data);
        return GMSSLSancDigestPreProcessUtils.derEncode(algorithmIdentifier, digest);
    }

    private static byte[] derEncode(AlgorithmIdentifier algId, byte[] hash) throws IOException {
        DigestInfo dInfo = new DigestInfo(algId, hash);
        return dInfo.getEncoded("DER");
    }
}

