/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.keystore.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLKeyStoreUtils {
    public static final String BKS_KEYSTORE_TYPE = "BKS";
    public static final String PKCS12_KEYSTORE_TYPE = "PKCS12";
    public static final String JKS_KEYSTORE_TYPE = "JKS";
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Deprecated
    public static KeyStore generateGMSSLKeyStore(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithBKS(password, rootCert, signAlias, signKey, signCert, encAlias, encKey, encCert);
    }

    @Deprecated
    public static KeyStore generateGMSSLKeyStore(String password, List<X509Certificate> rootCerts, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCerts, signAlias, signKey, signCert, encAlias, encKey, encCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithJKS(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCert, signAlias, signKey, signCert, encAlias, encKey, encCert, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithJKS(String password, List<X509Certificate> rootCerts, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCerts, signAlias, signKey, signCert, encAlias, encKey, encCert, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithBKS(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCert, signAlias, signKey, signCert, encAlias, encKey, encCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithPKCS12(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCert, signAlias, signKey, signCert, encAlias, encKey, encCert, PKCS12_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithJKS(String password, List<X509Certificate> rootCerts, int privateKeyIndex, String privateKeyPassword, String signAlias, X509Certificate signCert, String encAlias, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(privateKeyIndex, privateKeyPassword);
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCerts, signAlias, (PrivateKey)sdfPrivateKey, signCert, encAlias, (PrivateKey)sdfPrivateKey, encCert, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithBKS(String password, X509Certificate rootCert, int privateKeyIndex, String privateKeyPassword, String signAlias, X509Certificate signCert, String encAlias, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(privateKeyIndex, privateKeyPassword);
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCert, signAlias, (PrivateKey)sdfPrivateKey, signCert, encAlias, (PrivateKey)sdfPrivateKey, encCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithBKS(String password, List<X509Certificate> rootCerts, int privateKeyIndex, String privateKeyPassword, String signAlias, X509Certificate signCert, String encAlias, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(privateKeyIndex, privateKeyPassword);
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCerts, signAlias, (PrivateKey)sdfPrivateKey, signCert, encAlias, (PrivateKey)sdfPrivateKey, encCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithBKS(String password, List<X509Certificate> rootCerts, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, rootCerts, signAlias, signKey, signCert, encAlias, encKey, encCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLKeyStoreWithType(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert, String keystoreType) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(null, null);
        keyStore.setKeyEntry(signAlias, signKey, password.toCharArray(), new X509Certificate[]{signCert, rootCert});
        keyStore.setKeyEntry(encAlias, encKey, password.toCharArray(), new X509Certificate[]{encCert, rootCert});
        return keyStore;
    }

    public static KeyStore generateGMSSLKeyStoreWithType(String password, List<X509Certificate> trustCerts, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert, String keystoreType) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(null, null);
        keyStore.setKeyEntry(signAlias, signKey, password.toCharArray(), GMSSLKeyStoreUtils.generateCertArrays(trustCerts, signCert));
        keyStore.setKeyEntry(encAlias, encKey, password.toCharArray(), GMSSLKeyStoreUtils.generateCertArrays(trustCerts, encCert));
        return keyStore;
    }

    public static KeyStore generateGMSSLKeyStoreWithJKS(String password, List<X509Certificate> trustCerts, String signAlias, PrivateKey signKey, X509Certificate signCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(JKS_KEYSTORE_TYPE);
        keyStore.load(null, null);
        keyStore.setKeyEntry(signAlias, signKey, password.toCharArray(), GMSSLKeyStoreUtils.generateCertArrays(trustCerts, signCert));
        return keyStore;
    }

    private static X509Certificate[] generateCertArrays(List<X509Certificate> trustCerts, X509Certificate cert) {
        X509Certificate[] certArrays = new X509Certificate[trustCerts.size() + 1];
        certArrays[0] = cert;
        for (int i = 1; i < certArrays.length; ++i) {
            certArrays[i] = trustCerts.get(i - 1);
        }
        return certArrays;
    }

    @Deprecated
    public static KeyStore generateGMSSLTrustStore(X509Certificate rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(rootCert);
    }

    public static KeyStore generateGMSSLTrustStoreWithBKS(X509Certificate rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithJKS(X509Certificate rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCert, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithType(X509Certificate rootCert, String keystoreType) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("trust", rootCert);
        return keyStore;
    }

    @Deprecated
    public static KeyStore generateGMSSLTrustStore(X509Certificate[] rootCerts) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(rootCerts);
    }

    public static KeyStore generateGMSSLTrustStoreWithBKS(X509Certificate[] rootCerts) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCerts, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithJKS(X509Certificate[] rootCerts) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCerts, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithType(X509Certificate[] rootCerts, String keystoreType) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(null, null);
        for (int i = 0; i < rootCerts.length; ++i) {
            keyStore.setCertificateEntry("trust-" + i, rootCerts[i]);
        }
        return keyStore;
    }

    @Deprecated
    public static KeyStore generateGMSSLTrustStore(List<X509Certificate> rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(rootCert);
    }

    public static KeyStore generateGMSSLTrustStoreWithBKS(List<X509Certificate> rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCert, BKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithJKS(List<X509Certificate> rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithType(rootCert, JKS_KEYSTORE_TYPE);
    }

    public static KeyStore generateGMSSLTrustStoreWithType(List<X509Certificate> rootCert, String keystoreType) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(null, null);
        for (int i = 0; i < rootCert.size(); ++i) {
            keyStore.setCertificateEntry("trust-" + i, rootCert.get(i));
        }
        return keyStore;
    }

    public static void saveGMSSLKeyStore(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".keystore");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLPfx(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".pfx");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLBKSKeyStore(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".bks");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLJKSKeyStore(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".jks");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    @Deprecated
    public static void saveGMSSLKeyStoreEntry(String file, String password, String path) throws Exception {
        GMSSLKeyStoreUtils.saveGMSSLKeyStoreEntryWithBKS(file, password, path);
    }

    public static void saveGMSSLKeyStoreEntryWithBKS(String file, String password, String path) throws Exception {
        GMSSLKeyStoreUtils.saveGMSSLKeyStoreEntryWithType(file, password, path, BKS_KEYSTORE_TYPE);
    }

    public static void saveGMSSLKeyStoreEntryWithJKS(String file, String password, String path) throws Exception {
        GMSSLKeyStoreUtils.saveGMSSLKeyStoreEntryWithType(file, password, path, JKS_KEYSTORE_TYPE);
    }

    public static void saveGMSSLKeyStoreEntryWithType(String file, String password, String path, String keystoreType) throws Exception {
        InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)file);
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(in, password.toCharArray());
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(keyStore, password, path);
    }

    @Deprecated
    public static void printGMSSLKeyStore(String file, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        GMSSLKeyStoreUtils.printGMSSLKeyStoreWithBKS(file, password);
    }

    public static void printGMSSLKeyStoreWithBKS(String file, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        GMSSLKeyStoreUtils.printGMSSLKeyStoreWithType(file, password, BKS_KEYSTORE_TYPE);
    }

    public static void printGMSSLKeyStoreWithJKS(String file, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        GMSSLKeyStoreUtils.printGMSSLKeyStoreWithType(file, password, JKS_KEYSTORE_TYPE);
    }

    public static void printGMSSLKeyStoreWithType(String file, String password, String keystoreType) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)file);
        KeyStore keyStore = GMSSLKeyStoreUtils.generateKeystore(keystoreType);
        keyStore.load(in, password.toCharArray());
        GMSSLKeyStoreUtils.printGMSSLKeyStore(keyStore, password);
    }

    public static void printGMSSLKeyStore(KeyStore keyStore, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        System.out.println("Keystore type: " + keyStore.getType());
        System.out.println("Keystore provider: " + keyStore.getProvider());
        System.out.println();
        System.out.println("Your keystore contains " + keyStore.size() + " entries");
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            System.out.println();
            String alias = aliases.nextElement();
            System.out.println("Alias name: " + alias);
            System.out.println("Creation date: " + keyStore.getCreationDate(alias));
            if (keyStore.isKeyEntry(alias)) {
                System.out.println("Entry type: PrivateKeyEntry");
                Key key = keyStore.getKey(alias, password.toCharArray());
                System.out.println("Key Algorithm: " + key.getAlgorithm());
                if (key instanceof SecretKey) {
                    SdfPrivateKey sdfPrivateKey = SdfPrivateKey.getInstance((Object)key);
                    System.out.println(sdfPrivateKey);
                } else {
                    System.out.println(key);
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                System.out.println("Certificate chain length: " + certificateChain.length);
                for (int i = 1; i <= certificateChain.length; ++i) {
                    System.out.println("Certificate[" + i + "]: ");
                    System.out.println(certificateChain[i - 1]);
                }
                continue;
            }
            if (keyStore.isCertificateEntry(alias)) {
                System.out.println("Entry type: CertificateEntry");
                Certificate certificate = keyStore.getCertificate(alias);
                System.out.println(certificate);
                continue;
            }
            System.out.println("UnKnown type alias : " + alias);
        }
    }

    public static void saveGMSSLKeyStore(KeyStore keyStore, String password, String path) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.isKeyEntry(alias)) {
                Key key = keyStore.getKey(alias, password.toCharArray());
                String pri = alias + "_pri";
                if (key instanceof SecretKey) {
                    SdfPrivateKey sdfPrivateKey = SdfPrivateKey.getInstance((Object)key);
                    if (!$assertionsDisabled && sdfPrivateKey == null) {
                        throw new AssertionError();
                    }
                    GMSSLX509Utils.writeSdfPrivateKey((String)path, (String)pri, (PrivateKey)sdfPrivateKey);
                } else {
                    GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)pri, (PrivateKey)((PrivateKey)key));
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                for (int i = 1; i <= certificateChain.length; ++i) {
                    GMSSLX509Utils.writeCertificateToPem((String)path, (String)(alias + "_cert_" + i), (X509Certificate)((X509Certificate)certificateChain[i - 1]));
                }
                continue;
            }
            if (keyStore.isCertificateEntry(alias)) {
                Certificate certificate = keyStore.getCertificate(alias);
                GMSSLX509Utils.writeCertificateToPem((String)path, (String)(alias + "_cert"), (X509Certificate)((X509Certificate)certificate));
                continue;
            }
            logger.error("UnKnown type alias : " + alias);
        }
    }

    private static KeyStore generateKeystore(String keystoreType) throws NoSuchProviderException, KeyStoreException {
        if (BKS_KEYSTORE_TYPE.equals(keystoreType) || PKCS12_KEYSTORE_TYPE.equals(keystoreType)) {
            return KeyStore.getInstance(keystoreType, "BC");
        }
        return KeyStore.getInstance(keystoreType);
    }

    public static KeyStore readKeyStoreFromPath(String filename, char[] pw) throws Exception {
        KeyStore keyStore;
        try {
            InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filename);
            keyStore = KeyStore.getInstance(JKS_KEYSTORE_TYPE);
            keyStore.load(in, pw);
        }
        catch (Exception e) {
            InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filename);
            keyStore = KeyStore.getInstance(BKS_KEYSTORE_TYPE, "BC");
            keyStore.load(in, pw);
        }
        return keyStore;
    }

    public static Certificate readCertificateFromKeyStore(KeyStore keyStore, String alias) throws KeyStoreException {
        return keyStore.getCertificate(alias);
    }

    public static PrivateKey readPrivateKeyFromKeyStore(String filename, char[] pw, String alias) throws Exception {
        KeyStore keyStore = GMSSLKeyStoreUtils.readKeyStoreFromPath(filename, pw);
        return GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore(keyStore, pw, alias);
    }

    public static PrivateKey readPrivateKeyFromKeyStore(KeyStore keyStore, char[] pw, String alias) throws Exception {
        return (PrivateKey)keyStore.getKey(alias, pw);
    }

    static {
        boolean bl = $assertionsDisabled = !GMSSLKeyStoreUtils.class.desiredAssertionStatus();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        logger = LoggerFactory.getLogger(GMSSLExtensionUtils.class);
    }
}

