/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifier;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class GMSSLContentVerifierUtils {
    public static ContentVerifier generateContentVerifierByBC(String algorithm, PublicKey publicKey) throws OperatorCreationException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return verifierProvider.get(GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(algorithm, false));
    }

    public static ContentVerifierProvider generateContentVerifierProviderByBC(PublicKey publicKey) throws OperatorCreationException {
        return new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
    }

    public static ContentVerifierProvider generateContentVerifierProviderByBC(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return new JcaContentVerifierProviderBuilder().setProvider("BC").build(subjectPublicKeyInfo);
    }

    public static ContentVerifier generateContentVerifierByBC(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return verifierProvider.get(algorithmIdentifier);
    }

    public static ContentVerifier generateContentVerifierByYunhsm(String algorithm, PublicKey publicKey) throws OperatorCreationException {
        return GMSSLContentVerifierUtils.generateContentVerifierBySdf(SdfCryptoType.YUNHSM, algorithm, publicKey);
    }

    public static ContentVerifier generateContentVerifierByPcie(String algorithm, PublicKey publicKey) throws OperatorCreationException {
        return GMSSLContentVerifierUtils.generateContentVerifierBySdf(SdfCryptoType.PCIE, algorithm, publicKey);
    }

    public static ContentVerifier generateContentVerifierBySdf(SdfCryptoType sdfCryptoType, String algorithm, PublicKey publicKey) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(algorithm, false);
        return GMSSLContentVerifierUtils.generateContentVerifierBySdf(sdfCryptoType, algorithmIdentifier, publicKey);
    }

    public static ContentVerifier generateContentVerifierBySdf(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        try {
            return new SdfContentVerifier(sdfCryptoType, algorithmIdentifier, publicKey);
        }
        catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }

    public static ContentVerifier generateContentVerifierBySdfHSM(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        try {
            return new SdfContentVerifier(sdfCryptoType, algorithmIdentifier, publicKey, false);
        }
        catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

