/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.HsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHsmUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLYunHsmUtils.class);
    private static final String PYTHON_PATH = "/usr/local/xdsdfjni/parseconf.py";
    private static final String CONFIG_PATH;
    private static final String CONFIG_TEST_PATH;
    private static final String CONFIG_BAK_PATH;
    private static final String HSM_CONFIG_PATH;
    private static String JSON_PATH;

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port, String hsmModel) {
        String tomcatPath = GMSSLHsmUtils.getTomcatPath();
        return GMSSLHsmUtils.initYunHsmConfigAndTestConnect(tomcatPath, ip, port, hsmModel);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String tomcatPath, String ip, int port, String hsmModel) {
        GMSSLPkiCryptoInit.getHsmInstance(tomcatPath + HSM_CONFIG_PATH + CONFIG_PATH);
        String confPath = tomcatPath + HSM_CONFIG_PATH;
        try {
            YunHsmExceptionEnum yunHsmExceptionEnum;
            File file = new File(confPath);
            if (!file.exists()) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            if ((yunHsmExceptionEnum = GMSSLHsmUtils.testConnect(ip, port, hsmModel)) != YunHsmExceptionEnum.NORMAL) {
                return yunHsmExceptionEnum;
            }
            GMSSLHsmUtils.bakConfigFile(confPath);
            try {
                GMSSLHsmUtils.addPathByPython(confPath, false);
                GMSSLHsmUtils.changeConfigByPython(confPath, ip, port, hsmModel, false);
                YunhsmSdfSDKUtils.testConnection((String)(confPath + CONFIG_PATH + JSON_PATH), (boolean)true);
                HsmConnectionProviderImpl.getInstance().reopen();
                return YunHsmExceptionEnum.NORMAL;
            }
            catch (Exception e) {
                logger.error("\u4f7f\u7528\u65b0\u7684\u914d\u7f6e\u6587\u4ef6\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25\uff0c", (Throwable)e);
                GMSSLHsmUtils.resetHsm(confPath);
                return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
            }
        }
        catch (Exception e) {
            logger.error("\u914d\u7f6e\u5bc6\u7801\u673a\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static YunHsmExceptionEnum testConnect(String ip, int port, String hsmModel) {
        try {
            GMSSLPkiCryptoInit.getHsmInstance();
            String confPath = GMSSLHsmUtils.getBaseConfPath();
            GMSSLFileUtils.deleteDirectory((String)(confPath + File.separator + CONFIG_TEST_PATH));
            GMSSLHsmUtils.addPathByPython(confPath, true);
            GMSSLHsmUtils.changeConfigByPython(confPath, ip, port, hsmModel, true);
            YunhsmSdfSDKUtils.testConnection((String)(confPath + CONFIG_TEST_PATH + JSON_PATH), (boolean)true);
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static YunHsmExceptionEnum testConnect() {
        try {
            GMSSLPkiCryptoInit.getHsmInstance();
            String confPath = GMSSLHsmUtils.getBaseConfPath();
            YunhsmSdfSDKUtils.testConnection((String)(confPath + CONFIG_PATH + JSON_PATH), (boolean)true);
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static HsmInfoEntry getConfigInfo() throws Exception {
        String sh = "python2.7 /usr/local/xdsdfjni/parseconf.py 4 " + GMSSLHsmUtils.getConfPath(false);
        logger.debug("get env sh info is : {}", (Object)sh);
        String pythonPrint = GMSSLHsmUtils.runShAndGetPrint(sh);
        String[] s = pythonPrint.split(" ");
        HsmInfoEntry hsmInfoEntry = new HsmInfoEntry();
        hsmInfoEntry.setIp(s[1]);
        hsmInfoEntry.setPort(Integer.valueOf(s[2]));
        return hsmInfoEntry;
    }

    public static String getConfPath(boolean isTest) {
        String confPath = GMSSLHsmUtils.getBaseConfPath();
        String path = isTest ? confPath + CONFIG_TEST_PATH : confPath + CONFIG_PATH;
        return path;
    }

    private static String getBaseConfPath() {
        return GMSSLHsmUtils.getTomcatPath() + HSM_CONFIG_PATH;
    }

    private static String getTomcatPath() {
        String tomcatPath = System.getProperty("catalina.home");
        if (null == tomcatPath || tomcatPath.contains("Temp")) {
            tomcatPath = "/home/xdja/aliyun";
        }
        return tomcatPath;
    }

    private static void resetHsm(String confPath) throws Exception {
        File file = new File(confPath + CONFIG_PATH);
        if (file.isDirectory() && file.exists()) {
            GMSSLFileUtils.deleteDirectory((String)(confPath + CONFIG_PATH));
            GMSSLFileUtils.copyDir((String)(confPath + CONFIG_BAK_PATH), (String)(confPath + CONFIG_PATH));
        }
    }

    private static void bakConfigFile(String confPath) throws Exception {
        File file = new File(confPath + CONFIG_PATH);
        if (file.isDirectory() && file.exists()) {
            GMSSLFileUtils.copyDir((String)(confPath + CONFIG_PATH), (String)(confPath + CONFIG_BAK_PATH));
        }
    }

    private static void changeConfigByPython(String confPath, String ip, int port, String hsmModel, boolean isTestConf) {
        String path = isTestConf ? confPath + File.separator + CONFIG_TEST_PATH : confPath + File.separator + CONFIG_PATH;
        String sh = "python2.7  /usr/local/xdsdfjni/parseconf.py 3 " + path + " " + hsmModel + " " + ip + " " + port;
        logger.debug("change env sh info is : {}", (Object)sh);
        GMSSLHsmUtils.run(sh);
    }

    private static void addPathByPython(String confPath, boolean isTestConf) throws IOException {
        String path = isTestConf ? confPath + File.separator + CONFIG_TEST_PATH + File.separator : confPath + File.separator + CONFIG_PATH + File.separator;
        File file = new File(path);
        if (!file.exists()) {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        String sh = "python2.7  /usr/local/xdsdfjni/parseconf.py 1 " + path;
        logger.debug("add env sh info is : {}", (Object)sh);
        GMSSLHsmUtils.run(sh);
    }

    private static boolean run(String sh) {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            ps = rt.exec(sh);
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            is.close();
            reader.close();
            ps.destroy();
            logger.debug("=================\u5b8c\u6210=================");
            return true;
        }
        catch (Exception e) {
            logger.error(sh + " run is error ", (Throwable)e);
            return false;
        }
    }

    private static String runShAndGetPrint(String sh) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            String line;
            ps = rt.exec(sh);
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            LineNumberReader input = new LineNumberReader(reader);
            String str = "";
            while ((line = input.readLine()) != null) {
                str = str + line;
            }
            is.close();
            reader.close();
            ps.destroy();
            logger.debug("=================\u5b8c\u6210=================");
            return str;
        }
        catch (Exception e) {
            logger.error(sh + " run is error ", (Throwable)e);
            throw new Exception(e);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CONFIG_PATH = File.separator + "conf";
        CONFIG_TEST_PATH = File.separator + "confTest";
        CONFIG_BAK_PATH = File.separator + "confBak";
        HSM_CONFIG_PATH = File.separator + "conf" + File.separator + "hsm";
        JSON_PATH = File.separator + "etc" + File.separator + "xdsdfjni.json";
    }
}

