#command: python2.7 parseconf.py type param
#type=1, python2.7 parseconf.py 1 add_path
#type=2, python2.7 parseconf.py 2 del_path
#type=3, python2.7 parseconf.py 3 path hsmtype ip port
#type=4, python2.7 parseconf.py 4 path

import os,sys

default_path='/usr/local/xdsdfjni/'
default_json = '/usr/local/xdsdfjni/etc/xdsdfjni.json'

_type=sys.argv[1]

if _type not in ['1', '2', '3', '4']:
    print 'param is wrong, type is in [1, 2, 3, 4]!'
    sys.exit()

if _type == '1':
    add_path = sys.argv[2]
    if not add_path:
        print 'param is null!'
        sys.exit()
    os.system('cp -rf ' + default_path + '/* ' + add_path)
    new_json = add_path + '/etc/xdsdfjni.json'
    content = ''
    try:
        with open(default_json, 'r') as f:
            for line in f:
                if '"work_dir":' in line:
                    if ',' in line:
                        content += '"work_dir": "' + add_path + '",\n'
                    else:
                        content += '"work_dir": "' + add_path + '"\n'
                else:
                    content += line
    except Exception as e:
        print 'get json file error: %s' % str(e) 
    try:
        with open(new_json, 'w') as f:
            f.write(content)
    except Exception as e:
        print 'write json file error: %s' % str(e) 

elif _type == '2':
    del_path = sys.argv[2]
    if not del_path:
        print 'param is null!'
        sys.exit()
    os.system('rm -rf ' + del_path + '/*')

elif _type == '3':
    path = sys.argv[2]
    hsmtype = sys.argv[3]
    _ip = sys.argv[4]
    _port = sys.argv[5]
    if (not path) or (not hsmtype) or (not _ip) or (not _port): 
        print 'param is null!'
        sys.exit()
    cnt = ''
    try:
        flag = 0
        with open(path + '/etc/xdsdfjni.json', 'r') as f:
            for line in f:
                if '"ip":' in line:
                    if ',' in line:
                        cnt += '"ip": "' + _ip + '",\n'
                    else:
                        cnt += '"ip": "' + _ip + '"\n'
                elif '"port":' in line:
                    if ',' in line:
                        cnt += '"port": ' + _port + ',\n'
                    else:
                        cnt += '"port": ' + _port + '\n'
                elif '"server":' in line:
                    flag = 1
                    cnt += line
                elif (flag ==1) and ('"model":' in line):
                    if ',' in line:
                        cnt += '"model": "' + hsmtype + '",\n'
                    else:
                        cnt += '"model": "' + hsmtype + '"\n'
                else:
                    cnt += line
    except Exception as e:
        print 'read json file error: %s' % str(e) 
    try:
        with open(path + '/etc/xdsdfjni.json', 'w') as f:
            f.write(cnt)
    except Exception as e:
        print 'write json file error: %s' % str(e) 
    if hsmtype == "SJJ1507":
        try:
            flag = 0
            with open(path + '/etc/xdsdfjni.json', 'r') as f:
                for line in f:
                    if '"SJJ1507":' in line:
                        flag = 1
                    elif (flag == 1) and ('"config_file":' in line):
                        INICONF = path + '/' + line.split('"config_file":')[-1].strip().split(",")[0].strip('"') + '/tassConfig.ini'
                        break
        except Exception as e:
            print 'read json file error: %s' % str(e) 
        ini_content = ''
        try:
            flag = 0
            find_ip = 0
            find_port = 0
            with open(INICONF, 'r') as f:
                for line in f:
                    if '[Host 1]' in line:
                        flag = 1
                        ini_content += line
                    elif (flag == 1) and ('ip =' in line) and ('#ip' not in line):
                        ini_content += 'ip = ' + _ip + '\n'
                        find_ip = 1
                    elif (flag == 1) and ('port =' in line) and ('#port' not in line):
                        ini_content += 'port = ' + _port + '\n'
                        find_port = 1
                    else:
                        ini_content += line
        except Exception as e:
            print 'read ini conf file error: %s' % str(e) 
        try:
            with open(INICONF, 'w') as f:
                f.write(ini_content)
        except Exception as e:
            print 'write ini conf file error: %s' % str(e) 
    elif hsmtype == "SJJ1933":
        try:
            flag = 0
            with open(path + '/etc/xdsdfjni.json', 'r') as f:
                for line in f:
                    if '"SJJ1933":' in line:
                        flag = 1
                    if (flag == 1) and ('"config_file":' in line):
                        SDKCONF = path + '/' + line.split('"config_file":')[-1].strip().split(",")[0].strip('"')
                        break
        except Exception as e:
            print 'read json file error: %s' % str(e) 
        sdk_content = ''
        try:
            with open(SDKCONF, 'r') as f:
                for line in f:
                    if '"ip":' in line :
                        if ',' in line:
                            sdk_content += '"ip": "' + _ip + '",\n'
                        else:
                            sdk_content += '"ip": "' + _ip + '"\n'
                    elif '"port":' in line:
                        if ',' in line:
                            sdk_content += '"port": ' + _port + ',\n'
                        else:
                            sdk_content += '"port": ' + _port + '\n'
                    else:
                        sdk_content += line
        except Exception as e:
            print 'read conf file error: %s' % str(e) 
        try:
            with open(SDKCONF, 'w') as f:
                f.write(sdk_content)
        except Exception as e:
            print 'write ini conf file error: %s' % str(e) 
    else:
        pass
elif _type == '4':
    path = sys.argv[2]
    if not path:
        path='/usr/local/xdsdfjni/'
    try:
        flag = 0
        with open(path + '/etc/xdsdfjni.json', 'r') as f:
            for line in f:
                if '"server":' in line:
                    flag = 1
                elif (flag ==1) and ('"model":' in line):
                    model = line.split('"model":')[-1].strip().split(",")[0].strip('"')
                elif (flag == 1) and '"ip":' in line:
                    ip = line.split('"ip":')[-1].strip().split(",")[0].strip('"')
                elif (flag ==1) and ('"port":' in line):
                    port = line.split('"port":')[-1].strip().split(",")[0].strip('"')
        print model, ip, port
    except Exception as e:
        print 'read json file error: %s' % str(e) 

