/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;

public class GMSSLAES128ECBEncryptUtils {
    public static byte[] encryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getSymKey(kekIndex);
            byte[] bytes = GMSSLSM4ECBEncryptUtils.decryptByBCWithNoPadding(bean.getSecretKey().getEncoded(), kek);
            return GMSSLAES128ECBEncryptUtils.encryptByBc(bytes, data, paddingType);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(true, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
            case DONGJIN_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(true, SdfCryptoType.DONGJIN, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] decryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getSymKey(kekIndex);
            byte[] bytes = GMSSLSM4ECBEncryptUtils.decryptByBCWithNoPadding(bean.getSecretKey().getEncoded(), kek);
            return GMSSLAES128ECBEncryptUtils.decryptByBc(bytes, data, paddingType);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(false, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
            case DONGJIN_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(false, SdfCryptoType.DONGJIN, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] encrypt(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLAES128ECBEncryptUtils.encryptByBc(key, data, paddingType);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(true, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
            case DONGJIN_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(true, SdfCryptoType.DONGJIN, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        return GMSSLAES128ECBEncryptUtils.encryptByBc(key, data, paddingType);
    }

    public static byte[] decrypt(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLAES128ECBEncryptUtils.decryptByBc(key, data, paddingType);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(false, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
            case DONGJIN_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(false, SdfCryptoType.DONGJIN, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        return GMSSLAES128ECBEncryptUtils.decryptByBc(key, data, paddingType);
    }

    public static byte[] encryptByBc(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (paddingType) {
            case NoPadding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt((String)"AES/ECB/NoPadding", (byte[])key, (byte[])data);
            }
            case PKCS5Padding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt((String)"AES/ECB/PKCS5Padding", (byte[])key, (byte[])data);
            }
            case PKCS7Padding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt((String)"AES/ECB/PKCS7Padding", (byte[])key, (byte[])data);
            }
        }
        throw new Exception("un support the padding type " + paddingType);
    }

    public static byte[] decryptByBc(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (paddingType) {
            case NoPadding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt((String)"AES/ECB/NoPadding", (byte[])key, (byte[])data);
            }
            case PKCS5Padding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt((String)"AES/ECB/PKCS5Padding", (byte[])key, (byte[])data);
            }
            case PKCS7Padding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt((String)"AES/ECB/PKCS7Padding", (byte[])key, (byte[])data);
            }
        }
        throw new Exception("un support the padding type " + paddingType);
    }
}

