/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.dongjin.DongJinSdfSDK;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;

public class GMSSLKeKUtils {
    public static byte[] generateKeyWithKeKBySM4ECB(int kekIndex) throws Exception {
        return GMSSLKeKUtils.generateKek(kekIndex, SdfAlgIdSymmetric.SGD_SM4_ECB);
    }

    public static byte[] generateKeyWithKeKBySM1ECB(int kekIndex) throws Exception {
        return GMSSLKeKUtils.generateKek(kekIndex, SdfAlgIdSymmetric.SGD_SM1_ECB);
    }

    public static byte[] generateKek(int kekIndex, SdfAlgIdSymmetric sdfAlgIdSymmetric) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            byte[] bytes = GMSSLRandomUtils.generateRandom((int)16);
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getSymKey(kekIndex);
            return GMSSLSM4ECBEncryptUtils.encryptByBCWithNoPadding(bean.getSecretKey().getEncoded(), bytes);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                YunhsmSdfSDK sdfSDk = new YunhsmSdfSDK();
                return sdfSDk.generateKeyWithKek(sdfAlgIdSymmetric.getId(), kekIndex);
            }
            case DONGJIN_HSM: {
                DongJinSdfSDK dongJinSdfSDK = new DongJinSdfSDK();
                return dongJinSdfSDK.generateKeyWithKek(sdfAlgIdSymmetric.getId(), kekIndex);
            }
        }
        throw new Exception("generateKek method un support the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }
}

