/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.xdja.pcie.base.RSAPrivateKey;
import com.xdja.pcie.base.RSAPublicKey;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKey;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLRSAKeyUtils {
    public static final String RSA_ALGORITHM_NAME = "RSA";
    public static final int RSA_KEY_SIZE_1024 = 1024;
    public static final int RSA_KEY_SIZE_2048 = 2048;
    public static final int RSA_KEY_SIZE_3072 = 3072;
    public static final int RSA_KEY_SIZE_4096 = 4096;
    private static Logger logger;

    public static KeyPair generateRSAKeyPair(int keySize) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLRSAKeyUtils.generateKeyPairByBC(keySize);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.YUNHSM, keySize);
            }
            case DONGJIN_HSM: {
                return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.DONGJIN, keySize);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                RSArefKeyPair rsArefKeyPair = cryptConnection.generateRSAKeyPair(keySize);
                return new KeyPair(GMSSLSancConverUtils.converRSAPublicKey(rsArefKeyPair.getPublicKey()), GMSSLSancConverUtils.converRSAPrivateKey(rsArefKeyPair.getPrivateKey()));
            }
        }
        return GMSSLRSAKeyUtils.generateKeyPairByBC(keySize);
    }

    public static boolean writeKeyPairToHardWare(int index, String password, KeyPair keyPair) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                PcieSdfSDK pcieSdfSDK = new PcieSdfSDK();
                BCRSAPrivateCrtKey rsaPrivateCrtKey = (BCRSAPrivateCrtKey)keyPair.getPrivate();
                boolean b = GMSSLRSAKeyUtils.getPrivateKeyAccessRightFromHardware(index, password);
                if (!b) {
                    logger.error("\u83b7\u53d6\u79c1\u94a5\u8bbf\u95ee\u6743\u9650\u5931\u8d25\uff0c\u4e24\u7801\u6821\u9a8c\u672a\u901a\u8fc7\uff0cindex={}\uff0cpassword={}", (Object)index, (Object)password);
                    return false;
                }
                try {
                    pcieSdfSDK.importRSAPrivateKey(RSAPrivateKey.getInstance((BCRSAPrivateCrtKey)rsaPrivateCrtKey), index, password.getBytes(), false);
                    pcieSdfSDK.importRSAPublicKey(RSAPublicKey.getInstance((BCRSAPrivateCrtKey)rsaPrivateCrtKey), index, false);
                    pcieSdfSDK.importRSAPrivateKey(RSAPrivateKey.getInstance((BCRSAPrivateCrtKey)rsaPrivateCrtKey), index, password.getBytes(), true);
                    pcieSdfSDK.importRSAPublicKey(RSAPublicKey.getInstance((BCRSAPrivateCrtKey)rsaPrivateCrtKey), index, true);
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u5165RSA\u5bc6\u94a5\u5bf9\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
        }
        throw new Exception("un support write RSA KeyPair ToHardWare  with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password);
    }

    public static boolean getPrivateKeyAccessRightFromHardware(int index, String password) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean;
            try {
                bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, false);
            }
            catch (Exception e) {
                bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, true);
            }
            return bean.getPwd().equals(password);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return YunhsmSdfSDKUtils.checkPrivateKeyAccess((int)index, (String)password);
            }
            case PCI_E: {
                return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
            }
        }
        throw new Exception("the method un support the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static PublicKey getPublicKeyFromHardware(int index, boolean isEncryptKey) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, isEncryptKey);
            return bean.getPublicKey();
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                if (isEncryptKey) {
                    return GMSSLRSAKeyUtils.getEncryptPublicKeyByPcie(index);
                }
                return GMSSLRSAKeyUtils.getSignPublicKeyByPcie(index);
            }
            case XDJA_HSM: {
                if (isEncryptKey) {
                    return GMSSLRSAKeyUtils.getEncryptPublicKeyByYunhsm(index);
                }
                return GMSSLRSAKeyUtils.getSignPublicKeyByYunhsm(index);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                IRSArefPublicKey rsaPublicKey = isEncryptKey ? cryptConnection.getRSAPublicKey(index, GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType()) : cryptConnection.getRSAPublicKey(index, GMSSLSancKeyTypeEnum.SIGN.getKeyType());
                return GMSSLSancConverUtils.converRSAPublicKey(rsaPublicKey);
            }
        }
        throw new Exception("un support the method with the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static KeyPair generateKeyPairByBC(int keySize) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(RSA_ALGORITHM_NAME, "BC");
        kpGen.initialize(keySize);
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateKeyPairByYunHsm(int keySize) throws Exception {
        return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.YUNHSM, keySize);
    }

    public static KeyPair generateKeyPairBySdf(SdfCryptoType sdfCryptoType, int keySize) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.generateRSAKeyPair(keySize);
        }
        SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
        sdfSDK.init();
        SdfRsaKeyPair sdfRsaKeyPair = sdfSDK.generateKeyPairRsa(keySize);
        sdfSDK.release();
        SdfRSAPrivateKey rsaPrivateKey = sdfRsaKeyPair.getSdfRSAPrivateKey();
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getM()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getE()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getD()), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPrime()[0]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPrime()[1]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPexp()[0]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getPexp()[1]), BigIntegers.fromUnsignedByteArray((byte[])rsaPrivateKey.getCoef()));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_NAME, "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(spec);
        SdfRSAPublicKey rsaPublicKey = sdfRsaKeyPair.getSdfRSAPublicKey();
        RSAPublicKeySpec spec1 = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])rsaPublicKey.getM()), BigIntegers.fromUnsignedByteArray((byte[])rsaPublicKey.getE()));
        PublicKey pk = keyFactory.generatePublic(spec1);
        return new KeyPair(pk, privateKey);
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
        }
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index) throws Exception {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, true);
        }
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index) throws Exception {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return YunhsmSdfSDKUtils.checkPrivateKeyAccess((int)index, (String)password);
    }

    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return YunhsmSdfSDKUtils.checkPrivateKeyAccess((int)index, (String)password);
    }

    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        logger = LoggerFactory.getLogger(GMSSLRSAKeyUtils.class);
    }
}

