/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancDigestPreProcessUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class GMSSLSM3DigestUtils {
    public static byte[] digest(byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLSM3DigestUtils.digestByBC(data);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM3DigestUtils.digestBySdf(SdfCryptoType.PCIE, data);
            }
            case XDJA_HSM: {
                return GMSSLSM3DigestUtils.digestBySdf(SdfCryptoType.YUNHSM, data);
            }
            case DONGJIN_HSM: {
                return GMSSLSM3DigestUtils.digestBySdf(SdfCryptoType.DONGJIN, data);
            }
            case MINI_PCI_E: {
                return MiniPcieXKFUtils.sm3((byte[])data);
            }
        }
        return GMSSLSM3DigestUtils.digestByBC(data);
    }

    public static String digestByBC(String base64Data) {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByBC(data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static byte[] digestByBC(byte[] data) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(data, 0, data.length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        return out;
    }

    public static String digestByBCWithPublicKey(ECPublicKey publicKey, String base64Data) {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByBCWithPublicKey(publicKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static byte[] digestByBCWithPublicKey(ECPublicKey publicKey, byte[] data, byte[] userID) {
        SM3Digest digest = new SM3Digest();
        byte[] x = publicKey.getW().getAffineX().toByteArray();
        byte[] y = publicKey.getW().getAffineY().toByteArray();
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint G = ecParameterSpec.getG();
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, curve.getA().toBigInteger());
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, curve.getB().toBigInteger());
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, G.getAffineXCoord().toBigInteger());
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, G.getAffineYCoord().toBigInteger());
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, BigIntegers.fromUnsignedByteArray((byte[])x));
        GMSSLSM3DigestUtils.addFieldElement((Digest)digest, BigIntegers.fromUnsignedByteArray((byte[])y));
        byte[] z = new byte[digest.getDigestSize()];
        digest.doFinal(z, 0);
        digest.update(z, 0, z.length);
        digest.update(data, 0, data.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return out;
    }

    public static byte[] digestByBCWithPublicKey(ECPublicKey publicKey, byte[] data) {
        byte[] userID = GMSSLByteArrayUtils.hexDecode((String)"31323334353637383132333435363738");
        return GMSSLSM3DigestUtils.digestByBCWithPublicKey(publicKey, data, userID);
    }

    private static void addFieldElement(Digest digest, BigInteger p) {
        byte[] in = GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)p);
        digest.update(in, 0, in.length);
    }

    public static String digestByYunhsm(String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByYunhsm(data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static String digestByPcie(String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByPcie(data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static byte[] digestByYunhsm(byte[] data) throws Exception {
        return GMSSLSM3DigestUtils.digestBySdf(SdfCryptoType.YUNHSM, data);
    }

    public static byte[] digestByPcie(byte[] data) throws Exception {
        return GMSSLSM3DigestUtils.digestBySdf(SdfCryptoType.PCIE, data);
    }

    public static byte[] digestBySdf(SdfCryptoType sdfCryptoType, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSM3DigestUtils.digest(data);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfSM3Digest sm3Digest = new SdfSM3Digest(sdfCryptoType);
        sm3Digest.update(data, 0, data.length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        return out;
    }

    public static String digestByYunhsmWithPublicKey(ECPublicKey publicKey, String base64Data) throws SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByYunhsmWithPublicKey(publicKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static String digestByPcieWithPublicKey(ECPublicKey publicKey, String base64Data) throws SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] digest = GMSSLSM3DigestUtils.digestByPcieWithPublicKey(publicKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])digest);
    }

    public static byte[] digestByYunhsmWithPublicKey(ECPublicKey publicKey, byte[] data) throws SdfSDKException {
        return GMSSLSM3DigestUtils.digestBySdfWithPublicKey(SdfCryptoType.YUNHSM, publicKey, data);
    }

    public static byte[] digestByPcieWithPublicKey(ECPublicKey publicKey, byte[] data) throws SdfSDKException {
        return GMSSLSM3DigestUtils.digestBySdfWithPublicKey(SdfCryptoType.PCIE, publicKey, data);
    }

    public static byte[] digestBySdfWithPublicKey(SdfCryptoType sdfCryptoType, ECPublicKey publicKey, byte[] data) throws SdfSDKException {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSancDigestPreProcessUtils.sm3Digest(publicKey, data, null);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance((ECPublicKey)publicKey);
        byte[] pucID = Strings.toByteArray((String)"1234567812345678");
        SdfSM3Digest sm3Digest = new SdfSM3Digest(sdfCryptoType, pucID, sdfECCPublicKey);
        sm3Digest.update(data, 0, data.length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        return out;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

