/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.operator.utils.GMSSLJcaContentSignerBuilder;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class GMSSLContentSignerUtils {
    public static ContentSigner generateContentSignerByBC(GMSSLSignatureAlgorithm signatureAlgorithm, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerByBC(signatureAlgorithm.getSigAlgName(), privateKey);
    }

    public static ContentSigner generateContentSignerByBC(String algorithm, PrivateKey privateKey, boolean isWithParam) throws OperatorCreationException {
        if (isWithParam) {
            return GMSSLContentSignerUtils.generateContentSignerByBCWithParam(algorithm, privateKey);
        }
        return GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, privateKey);
    }

    public static ContentSigner generateContentSignerByBC(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(algorithm);
        return contentSignerBuilder.build(privateKey);
    }

    public static ContentSigner generateContentSignerByBCWithParam(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        GMSSLJcaContentSignerBuilder contentSignerBuilder = new GMSSLJcaContentSignerBuilder(algorithm);
        return contentSignerBuilder.build(privateKey);
    }

    public static ContentSigner generateContentSignerByYunhsm(String algorithm, PrivateKey privateKey, boolean isWithParam) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, privateKey, isWithParam, 256);
    }

    public static ContentSigner generateContentSignerByYunhsm(String algorithm, PrivateKey privateKey, boolean isWithParam, int bits) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.YUNHSM, algorithm, privateKey, isWithParam, bits);
    }

    public static ContentSigner generateContentSignerByYunhsm(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.YUNHSM, algorithm, privateKey);
    }

    public static ContentSigner generateContentSignerByPcie(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.PCIE, algorithm, privateKey);
    }

    public static ContentSigner generateContentSignerByPcie(String algorithm, PrivateKey privateKey, boolean isWithParam) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.PCIE, algorithm, privateKey, isWithParam);
    }

    public static ContentSigner generateContentSignerBySDF(SdfCryptoType sdfCryptoType, String algorithm, PrivateKey privateKey, boolean isWithParam) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(sdfCryptoType, algorithm, privateKey, isWithParam, 256);
    }

    public static ContentSigner generateContentSignerBySDF(SdfCryptoType sdfCryptoType, String algorithm, PrivateKey privateKey, boolean isWithParam, int bits) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(algorithm, isWithParam);
        if (!(privateKey instanceof SdfPrivateKey)) {
            throw new OperatorCreationException(" un support private key type " + privateKey.getClass());
        }
        try {
            return new SdfContentSigner(sdfCryptoType, algorithmIdentifier, (SdfPrivateKey)privateKey, bits);
        }
        catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }

    public static ContentSigner generateContentSignerBySDF(SdfCryptoType sdfCryptoType, String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(sdfCryptoType, algorithm, privateKey, false);
    }

    public static ContentSigner generateContentSignerBySDFHSM(SdfCryptoType sdfCryptoType, String algorithm, PrivateKey privateKey) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(algorithm, false);
        if (!(privateKey instanceof SdfPrivateKey)) {
            throw new OperatorCreationException(" un support private key type " + privateKey.getClass());
        }
        try {
            return new SdfContentSigner(sdfCryptoType, algorithmIdentifier, (SdfPrivateKey)privateKey, false);
        }
        catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

