/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.tomcat.utils.ServerXmlResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLTomcatUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLTomcatUtils.class);
    public static final String GMSSLV11 = "GMSSLV1.1";
    public static final String GMSSLSDFYUNHSMV11 = "GMSSLSDFYUNHSMV1.1";
    public static final String GMSSLSDFPCIEV11 = "GMSSLSDFPCIEV1.1";
    public static final String GMSSLXDJASDFYUNHSMV11 = "GMSSLXDJASDFYUNHSMV1.1";
    public static final String GMSSLXDJASDFPCIEV11 = "GMSSLXDJASDFPCIEV1.1";

    @Deprecated
    public static void openHttpsPortByBC(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, false);
    }

    @Deprecated
    public static void openHttpsPortByJKSWithRSA(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, true);
    }

    public static void openHttpsPortByJKSWithRSA(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.openHttpsPortByJKSWithRSA(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port);
    }

    public static void openHttpsPortByJKSWithNIST(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.openHttpsPortByJKSWithNIST(trustCerts, serveCert, serverPriKey, port, tomcatPath);
    }

    public static void openHttpsPortByJKSWithNIST(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port, String tomcatPath) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByJKSWithRSA(trustCerts, serveCert, null, serverPriKey, null, tomcatPath, port);
    }

    public static void openHttpsPortByYJKSWithClientAuth(List<X509Certificate> trustCerts, X509Certificate serveCert, PrivateKey serverPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.saveKeyStore(trustCerts, serveCert, null, serverPriKey, null, tomcatPath, String.valueOf(port), true);
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPortWithClientAuthByJKS(tomcatPath, GMSSLV11, port);
    }

    public static void openHttpsPortByJKSWithNist(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, true);
    }

    public static void openHttpsPortByJKSWithNist(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.openHttpsPortByBC(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, true);
    }

    public static void openHttpsPortByJKSWithRSA(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, true);
    }

    public static void openHttpsPortByBC(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, false);
    }

    public static void openHttpsPortByBC(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, false, false);
    }

    public static void openHttpsPortByBCWithClientAuth(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortByBC(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, true, false);
    }

    public static void openHttpsPortByBC(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port, boolean clientAuth, boolean isJKS) throws Exception {
        ArrayList<X509Certificate> trustCerts = new ArrayList<X509Certificate>();
        trustCerts.add(trustCert);
        GMSSLTomcatUtils.openHttpsPortByBC(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, port, clientAuth, isJKS);
    }

    public static void openHttpsPortByBC(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port, boolean clientAuth, boolean isJKS) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(trustCerts, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port), isJKS);
        if (isJKS) {
            serverXmlResolver.addTomcatHttpsPortWithJks(tomcatPath, port);
        } else if (clientAuth) {
            serverXmlResolver.addTomcatHttpsPortWithClientAuth(tomcatPath, GMSSLV11, port);
        } else {
            serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port);
        }
    }

    public static void openHttpsPortByYunHsm(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCert, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLSDFYUNHSMV11);
    }

    public static void openHttpsPortByYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, int port) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLSDFYUNHSMV11);
    }

    public static void openHttpsPortByYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLSDFYUNHSMV11);
    }

    public static void openHttpsPortByYunHsmWithClientAuth(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, true, GMSSLSDFYUNHSMV11);
    }

    public static void openHttpsPortByPCIE(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCert, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLSDFPCIEV11);
    }

    public static void openHttpsPortByPCIE(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLSDFPCIEV11);
    }

    public static void openHttpsPortByPCIEWithClientAuth(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, true, GMSSLSDFPCIEV11);
    }

    public static void openHttpsPortByXDJAYunHsm(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCert, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLXDJASDFYUNHSMV11);
    }

    public static void openHttpsPortByXDJAYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLXDJASDFYUNHSMV11);
    }

    public static void openHttpsPortByXDJAPCIE(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCert, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLXDJASDFPCIEV11);
    }

    public static void openHttpsPortByXDJAPCIE(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, false, GMSSLXDJASDFPCIEV11);
    }

    public static void openHttpsPortBySdf(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port, boolean isClientAuth, String sdfType) throws Exception {
        ArrayList<X509Certificate> trustCerts = new ArrayList<X509Certificate>();
        trustCerts.add(trustCert);
        GMSSLTomcatUtils.openHttpsPortBySdf(trustCerts, serveSignCert, serverEncCert, caServerPrivateKeyIndex, caServerPrivateKeyPassword, tomcatPath, port, isClientAuth, sdfType);
    }

    public static void openHttpsPortBySdf(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port, boolean isClientAuth, String sdfType) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            PrivateKey signPrivateKey = GMSSLHsmKeyStoreUtils.getAsymKey(caServerPrivateKeyIndex, false).getPrivateKey();
            PrivateKey encPrivateKey = GMSSLHsmKeyStoreUtils.getAsymKey(caServerPrivateKeyIndex, true).getPrivateKey();
            GMSSLTomcatUtils.openHttpsPortByBC(trustCerts, serveSignCert, serverEncCert, signPrivateKey, encPrivateKey, tomcatPath, port, false, false);
            return;
        }
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword);
        GMSSLTomcatUtils.saveKeyStore(trustCerts, serveSignCert, serverEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port), false);
        if (isClientAuth) {
            serverXmlResolver.addTomcatHttpsPortWithClientAuth(tomcatPath, sdfType, port);
        } else {
            serverXmlResolver.addTomcatHttpsPort(tomcatPath, sdfType, port);
        }
    }

    public static void openHttpsPortByKeyStoreWithBKS(KeyStore serverKeyStore, KeyStore trustKeyStore, int port, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        String serverKeyStoreName = "signAndEncCert_" + serverKeyStorePassword;
        String trustKeyStoreName = "ca_" + trustKeyStorePassword;
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(tomcatPath, serverKeyStore, trustKeyStore, port, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName, true);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port, false, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
    }

    public static void openHttpsPortByKeyStoreWithJKS(KeyStore serverKeyStore, KeyStore trustKeyStore, int port, boolean isClientAuth, String serverKeyStorePassword, String trustKeyStorePassword) throws Exception {
        String tomcatPath = System.getProperty("catalina.home");
        String serverKeyStoreName = "signAndEncCert_" + serverKeyStorePassword;
        String trustKeyStoreName = "ca_" + trustKeyStorePassword;
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(tomcatPath, serverKeyStore, trustKeyStore, port, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName, false);
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, GMSSLV11, port, false, isClientAuth, serverKeyStorePassword, trustKeyStorePassword, serverKeyStoreName, trustKeyStoreName);
    }

    private static void saveKeyStore(String tomcatPath, KeyStore serverKeyStore, KeyStore trustKeyStore, int port, String serverKeyStorePassword, String trustKeyStorePassword, String serverKeyStoreName, String trustKeyStoreName, boolean isBks) throws Exception {
        String path = tomcatPath + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator;
        File pathf = new File(path);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        if (isBks) {
            GMSSLKeyStoreUtils.saveGMSSLBKSKeyStore(serverKeyStore, serverKeyStorePassword, path, serverKeyStoreName);
            GMSSLKeyStoreUtils.saveGMSSLBKSKeyStore(trustKeyStore, trustKeyStorePassword, path, trustKeyStoreName);
        } else {
            GMSSLKeyStoreUtils.saveGMSSLJKSKeyStore(serverKeyStore, serverKeyStorePassword, path, serverKeyStoreName);
            GMSSLKeyStoreUtils.saveGMSSLJKSKeyStore(trustKeyStore, trustKeyStorePassword, path, trustKeyStoreName);
        }
    }

    public static void openHttpPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpPort(tomcatPath, port);
    }

    public static void closeTomcatPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.closeTomcatPort(tomcatPath, port);
    }

    @Deprecated
    public static boolean restartTomcat(String tomcatPath) {
        if (!GMSSLTomcatUtils.shutdownTomcat(tomcatPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    @Deprecated
    public static boolean restartTomcat(String tomcatPath, String shutdownShellPath) {
        if (!GMSSLTomcatUtils.run(tomcatPath, "shutdown.sh " + tomcatPath, true, shutdownShellPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    public static boolean shutdownTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "shutdown", false, new String[0]);
    }

    public static boolean startupTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "startup", false, new String[0]);
    }

    private static void saveKeyStore(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port, boolean isJks) throws Exception {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(trustCert);
        GMSSLTomcatUtils.saveKeyStore(certs, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, path, port, isJks);
    }

    public static void saveKeyStore(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port, boolean isJKS) throws Exception {
        File pathf = new File(path = path + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";
        KeyStore serverKeyStore = isJKS ? (null == serverEncCert ? GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithJKS(password, trustCerts, signAlias, serverSignPriKey, serveSignCert) : GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, trustCerts, signAlias, serverSignPriKey, serveSignCert, encAlias, serverEncPriKey, serverEncCert, "JKS")) : GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithType(password, trustCerts, signAlias, serverSignPriKey, serveSignCert, encAlias, serverEncPriKey, serverEncCert, "BKS");
        for (int i = 0; i < trustCerts.size(); ++i) {
            GMSSLX509Utils.writeCertificateToPem((String)path, (String)("ca_" + i), (X509Certificate)trustCerts.get(i));
            GMSSLX509Utils.writeObjectToPem((String)path, (String)("ca_public_" + i), (Object)trustCerts.get(i).getPublicKey());
            GMSSLX509Utils.writeCertificateToCer((String)path, (String)("ca_" + i), (X509Certificate)trustCerts.get(i));
        }
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"sign", (X509Certificate)serveSignCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_public", (Object)serveSignCert.getPublicKey());
        KeyStore trustKeyStore = isJKS ? GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithJKS(trustCerts) : GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS(trustCerts);
        if (serverSignPriKey instanceof SdfPrivateKey) {
            GMSSLX509Utils.writeSdfPrivateKey((String)path, (String)"ca_server_key", (PrivateKey)serverSignPriKey);
        } else {
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_private", (Object)serverSignPriKey);
            if (null != serverEncCert) {
                GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"enc");
                GMSSLX509Utils.writeObjectToPem((String)path, (String)"enc_private", (Object)serverEncPriKey);
            }
            GMSSLKeyStoreUtils.printGMSSLKeyStore(trustKeyStore, password);
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"sign");
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)trustKeyStore, (char[])"password".toCharArray(), (String)(path + "/trust"));
        }
        if (null != serverEncCert) {
            GMSSLX509Utils.writeCertificateToPem((String)path, (String)"enc", (X509Certificate)serverEncCert);
            GMSSLX509Utils.writeCertificateToCer((String)path, (String)"enc", (X509Certificate)serverEncCert);
        }
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sign", (X509Certificate)serveSignCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(serverKeyStore, "password", path, "server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(trustKeyStore, "password", path, "trust");
    }

    private static boolean run(String tomcatPath, String shName, boolean isUseShutdownSh, String ... shPath) {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            String os = System.getProperty("os.name");
            if (shName.contains("shut")) {
                logger.info("=================\u5f00\u59cb\u5173\u95edTomcat=================");
            } else {
                logger.info("=================\u5f00\u59cb\u542f\u52a8Tomcat=================");
            }
            ps = os.startsWith("Windows") ? rt.exec("cmd /c " + tomcatPath + File.separator + "bin" + File.separator + shName + ".bat", null, new File(tomcatPath)) : (isUseShutdownSh ? rt.exec("sh " + shPath[0] + File.separator + shName, null, new File(shPath[0])) : rt.exec("sh " + tomcatPath + File.separator + "bin" + File.separator + shName + ".sh", null, new File(tomcatPath)));
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            is.close();
            reader.close();
            ps.destroy();
            logger.info("=================\u5b8c\u6210=================");
            return true;
        }
        catch (Exception e) {
            logger.error(shName + " tomcat is error ", (Throwable)e);
            return false;
        }
    }

    public static boolean restartTomcat() {
        String tomcatPath = System.getProperty("catalina.home");
        if (!GMSSLTomcatUtils.shutdownTomcat(tomcatPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    public static boolean restartTomcatWithSh() {
        InputStream resourceAsStream = GMSSLTomcatUtils.class.getClassLoader().getResourceAsStream("restart.sh");
        return GMSSLTomcatUtils.restart(resourceAsStream);
    }

    private static boolean restart(final InputStream inputStream) {
        final String home = System.getProperty("catalina.home");
        logger.debug("Restart Tomcat Begin {}", (Object)home);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String restartCMDPath = "$CATALINA_HOME/bin/restart.sh";
                    restartCMDPath = restartCMDPath.replace("$CATALINA_HOME", home);
                    File restartFile = new File(restartCMDPath);
                    if (!restartFile.exists()) {
                        logger.debug("restart.sh \u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u590d\u5236\u6587\u4ef6...");
                        Files.copy(inputStream, restartFile.toPath(), new CopyOption[0]);
                        logger.debug("restart.sh \u590d\u5236\u6587\u4ef6\u6210\u529f...");
                    }
                    boolean chmod = restartFile.setExecutable(true, true);
                    logger.debug("restart.sh \u6dfb\u52a0\u53ef\u6267\u884c\u6743\u9650 {}", (Object)chmod);
                    GMSSLTomcatUtils.runCmd("chmod 755 " + restartCMDPath);
                    long millis = 9000L;
                    logger.debug("Restart Tomcat Sleep {}ms", (Object)millis);
                    Thread.sleep(millis);
                    logger.debug("Restart Tomcat Weak Up {}ms", (Object)millis);
                    GMSSLTomcatUtils.runCmd(restartCMDPath);
                }
                catch (Exception e) {
                    logger.error("\u91cd\u542ftomcat\u5931\u8d25", (Throwable)e);
                    throw new RuntimeException("\u91cd\u542ftomcat\u5931\u8d25", e);
                }
            }
        });
        return true;
    }

    private static void runCmd(String cmd) throws IOException, InterruptedException {
        String line;
        logger.debug("Start Run Cmd {}", (Object)cmd);
        Process process = Runtime.getRuntime().exec(cmd);
        StringBuilder output = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            output.append(line + "\n");
        }
        reader.close();
        int exitVal = process.waitFor();
        if (exitVal == 0) {
            logger.debug("Run Cmd Success!", (Object)cmd);
            logger.debug("Run Cmd output is {}", (Object)output.toString());
        } else {
            logger.error("Run Cmd Fail! exitVal = {}", (Object)exitVal);
        }
    }
}

