package com.xdja.pki.gmssl.crypto.init;

import java.io.File;

public class GMSSLHSMConstants {

    public final static String CONFIG_PATH = System.getProperty("catalina.home") + File.separator
            + "conf" + File.separator + "gmssl-hsm" + File.separator;
    public final static File CONFIG_PATH_FILE = new File(CONFIG_PATH);
    public final static String CONFIG_FILE_NAME = "hsm-server.conf";
    public final static String CONFIG_FILE_PATH = CONFIG_PATH + File.separator + CONFIG_FILE_NAME;
    public final static File CONFIG_FILE = new File(CONFIG_FILE_PATH);
    public final static String SIGN_FILE_NAME = "sign.pfx";
    public final static String ENC_FILE_NAME = "enc.pfx";
    public final static String TRUST_FILE_NAME = "trust.p7b";
    public final static String PKCA12_TYPE = "PKCS12";
    public final static String PKCA7_TYPE = "PKCS7";
    public final static String PROVIDER = "BC";
    public final static String KEYSTORE_PASSWORD = "xdja1234";
    public final static String TRUST_KEYSTORE_PASSWORD_DEFAULT = "";
    public final static String KEYSTORE_TYPE = "BKS";
    public final static String SSL_PROTOCOL = "GMSSLv1.1";
    public final static String HSM_SERVER_IP_HOLDER = "$IP$";
    public final static String HSM_SERVER_PORT_HOLDER = "$PORT$";
    public final static String HSM_SERVER_URI = "https://" + HSM_SERVER_IP_HOLDER + ":" + HSM_SERVER_PORT_HOLDER + "/v1/keys";
    public final static String HSM_KEYSTORE_PATH = GMSSLHSMConstants.CONFIG_PATH + "key.keystore";
    public final static File HSM_KEYSTORE_FILE = new File(HSM_KEYSTORE_PATH);
    public static final String ASYMMETRIC_SIGN_ALIAS = "asym_sign_{0}";
    public static final String ASYMMETRIC_ENC_ALIAS = "asym_enc_{0}";
    public static final String SYMMETRIC_ALIAS = "sym_{0}";
}
