package com.xdja.pki.gmssl.crypto.init;

import com.xdja.SafeKey.utils.pool.MiniPcieConnectionPool;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.security.KeyStore;
import java.util.Map;

/**
 * @ClassName GMSSLPkiCryptoInit
 * @Description TODO
 * @Date 2020/5/18 16:24
 * @Author FengZhen
 */
public class GMSSLPkiCryptoInit {

    private static String JSON_PATH = File.separator + "etc" + File.separator + "xdsdfjni.json";
    private static Logger logger = LoggerFactory.getLogger(GMSSLPkiCryptoInit.class);
    private static final GMSSLPkiCryptoInit INSTANCE = new GMSSLPkiCryptoInit();
    private GMSSLCryptoType cryptoType = GMSSLCryptoType.BC;
    private KeyStore hsmKeyStore;

    /**
     * hsmKeyStore解析结果
     * 非对称密钥 1-30 签名  31-60 加密
     * 对称密钥 101 - 130
     */
    private Map<String, GMSSLHsmKeyStoreBean> hsmKeyStoreMap;

    private GMSSLPkiCryptoInit() {
    }

    public static GMSSLCryptoType getCryptoType() {
        return INSTANCE.cryptoType;
    }

    public static GMSSLCryptoType getSdfCryptoType() throws Exception {
        if (!INSTANCE.cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + INSTANCE.cryptoType);
        }
        return INSTANCE.cryptoType;
    }

    /**
     * BC软实现
     */
    public static void getBCInstance() {
        INSTANCE.cryptoType = GMSSLCryptoType.BC;
    }

    /**
     * 信大捷安适配第三方密码机实现
     */
    public static void getHsmInstance() {
        String jsonPath = GMSSLHsmUtils.getConfPath(false) + JSON_PATH;
        logger.info("读取json文件路径为：" + jsonPath);
        HsmUtils.resetHsmconfigPath(jsonPath);
        HsmUtils.setHsmType();
        INSTANCE.cryptoType = GMSSLCryptoType.XDJA_HSM;
    }


    /**
     * 信大捷安密码机实现
     */
    public static void getXdjaYunHsmInstance() {
        INSTANCE.cryptoType = GMSSLCryptoType.XDJA_HSM;
    }

    /**
     * PCIE实现
     */
    public static void getPcieInstance() {
        PcieConnectionProviderImpl.getInstance();
        INSTANCE.cryptoType = GMSSLCryptoType.PCI_E;
    }

    /**
     * 东进密码机实现
     */
    public static void getDJHsmInstance() {
        INSTANCE.cryptoType = GMSSLCryptoType.DONGJIN_HSM;
    }


    /**
     * MiniPCIE实现
     */
    public static void getMiniPcieInstance() {
        MiniPcieConnectionPool.getInstance();
        INSTANCE.cryptoType = GMSSLCryptoType.MINI_PCI_E;
    }

    /**
     * 三未信安密码机实现
     */
    public static void getSancHsmInstance() throws Exception {
        GMSSLSancConnectionUtils.init();
        INSTANCE.cryptoType = GMSSLCryptoType.SANC_HSM;
    }

    /**
     * 三未信安密码机实现 本地路径调试使用  正常上服务不建议使用
     *
     * @param configPath 配置文件路径
     */
    public static void getSancHsmInstance(String configPath) throws Exception {
        GMSSLSancConnectionUtils.init(configPath);
        INSTANCE.cryptoType = GMSSLCryptoType.SANC_HSM;
    }


    public static void setHsmKeyStore(KeyStore keyStore) {
        INSTANCE.hsmKeyStore = keyStore;
        INSTANCE.hsmKeyStoreMap = GMSSLHsmKeyStoreUtils.analysisKeyStore(keyStore);
    }

    public static KeyStore getHsmKeyStore() {
        return INSTANCE.hsmKeyStore;
    }

    public static Map<String, GMSSLHsmKeyStoreBean> getHsmKeyStoreMap() {
        return INSTANCE.hsmKeyStoreMap;
    }

    /**
     * 是否为软算法
     *
     * @return true: 软算法
     */
    public static boolean isHsmServer() {
        return null != INSTANCE.hsmKeyStoreMap && !INSTANCE.hsmKeyStoreMap.isEmpty();
    }
}
