package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.dongjin.DongJinSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;

/**
 * @description: 生成会话密钥
 * @author: feng zhen
 * @date: 2020/8/14 15:31
 **/
public class GMSSLKeKUtils {

    /**
     * 使用密钥加密密钥 ，SM4 ECB模式 生成 生成会话密钥密文   SdfAlgIdSymmetric.SGD_SM4_ECB
     *
     * @param kekIndex 密钥加密密钥 kek的密钥索引
     * @return
     * @throws Exception
     */
    public static byte[] generateKeyWithKeKBySM4ECB(int kekIndex) throws Exception {
        return generateKek(kekIndex, SdfAlgIdSymmetric.SGD_SM4_ECB);
    }

    /**
     * 使用密钥加密密钥 ，SM1 ECB模式 生成 生成会话密钥密文  SdfAlgIdSymmetric.SGD_SM1_ECB
     *
     * @param kekIndex 密钥加密密钥 kek的密钥索引
     * @return
     * @throws Exception
     */
    public static byte[] generateKeyWithKeKBySM1ECB(int kekIndex) throws Exception {
        return generateKek(kekIndex, SdfAlgIdSymmetric.SGD_SM1_ECB);
    }


    /**
     * 使用密钥加密密钥生成会话密钥密文
     *
     * @param kekIndex          密钥加密密钥索引
     * @param sdfAlgIdSymmetric 对称加密算法
     * @return
     * @throws Exception
     */
    public static byte[] generateKek(int kekIndex, SdfAlgIdSymmetric sdfAlgIdSymmetric) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            byte[] bytes = GMSSLRandomUtils.generateRandom(16);
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getSymKey(kekIndex);
            return GMSSLSM4ECBEncryptUtils.encryptByBCWithNoPadding(bean.getSecretKey().getEncoded(), bytes);
        }

        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM:
                SdfSDK sdfSDk = new YunhsmSdfSDK();
                return sdfSDk.generateKeyWithKek(sdfAlgIdSymmetric.getId(), kekIndex);
            case DONGJIN_HSM:
                SdfSDK dongJinSdfSDK = new DongJinSdfSDK();
                return dongJinSdfSDK.generateKeyWithKek(sdfAlgIdSymmetric.getId(), kekIndex);
            default:
                throw new Exception("generateKek method un support the crypto type " + GMSSLPkiCryptoInit.getCryptoType());
        }
    }
}
