package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.MessageDigest;
import java.security.Security;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/7/1 14:35
 **/
public class GMSSLSHA512DigestUtils {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /**
     * SHA384 hash算法
     *
     * @param data 原数据
     * @return
     * @throws Exception
     */
    public static byte[] digest(byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return digestByBC(data);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM:
                return digestBySdf(SdfCryptoType.YUNHSM, data);
            case SANC_HSM:
            case MINI_PCI_E:
            case BC:
            default:
                return digestByBC(data);
        }
    }

    /**
     * @param data Base64字符串
     * @return String Base64字符串
     * @throws Exception
     */
    public static String digestByBC(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(digestByBC(GMSSLByteArrayUtils.base64Decode(data)));
    }

    /**
     * @param data byte数组
     * @return byte[] 数组
     * @throws Exception
     */
    public static byte[] digestByBC(byte[] data) throws Exception {
        MessageDigest instance = MessageDigest.getInstance("SHA-512", BouncyCastleProvider.PROVIDER_NAME);
        return instance.digest(data);
    }

    /**
     * @param data Base64字符串
     * @return String Base64字符串
     * @throws Exception
     */
    public static String digestByYunHsm(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(digestByYunHsm(GMSSLByteArrayUtils.base64Decode(data)));
    }

    /**
     * @param data byte数组
     * @return byte[] 数组
     * @throws Exception
     */
    public static byte[] digestByYunHsm(byte[] data) throws Exception {
        return digestBySdf(SdfCryptoType.YUNHSM, data);
    }

    public static byte[] digestBySdf(SdfCryptoType sdfCryptoType, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() ||
                GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return digest(data);
        }
        SdfSHADigest sdfSHADigest = new SdfSHADigest(sdfCryptoType.getSdfSDK(), SdfAlgIdHash.SGD_SHA512);
        sdfSHADigest.update(data, 0, data.length);
        byte[] digest = new byte[sdfSHADigest.getDigestSize()];
        sdfSHADigest.doFinal(digest, 0);
        return digest;
    }
}
