package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.*;
import com.xdja.pki.gmssl.sdf.SdfSDKException;

/**
 * @author sxy
 * @description
 * @date 2019年11月19日 21:54
 **/
public class GMSSLSdfSM2SignerUtils {

    public static SdfECBaseSigner generateSM2Signer(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        if (Constants.SDF_SM2_USED_BC_SM3) {
            return new SdfEcSignerWithSoftDigest(sdfCryptoType);
        } else {
            return new SdfECSigner(sdfCryptoType);
        }
    }

    public static SdfECBaseSigner generateSM2Signer(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        return generateSM2Signer(sdfCryptoType, signAlgName, 256);
    }

    public static SdfECBaseSigner generateSM2Signer(SdfCryptoType sdfCryptoType, String signAlgName, int bits) throws SdfSDKException {
        if (Constants.SDF_SM2_USED_BC_SM3) {
            return new SdfEcSignerWithSoftDigest(sdfCryptoType, signAlgName, bits);
        } else {
            return new SdfECSigner(sdfCryptoType, signAlgName, bits);
        }
    }
}
